#!/usr/bin/python
#
#  $Id: info.py,v 1.3 1999/12/07 11:28:23 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""
"""

__version__ = '$Id: info.py,v 1.3 1999/12/07 11:28:23 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'

import string, sys, os

import Pyrite
from Pyrite import _
from Pyrite.Application import Application
from Sulfur.Options import Boolean, String, O_NOCONFIG, O_NONINTERACTIVE, O_MULTIPLE
import Sulfur

class App(Application):
    name = 'Pyrite Info'
    version = Pyrite.version
    author = 'Rob Tillotson <robt@debian.org>'
    description = _("Print information about the Pyrite installation.")

    options = [
	Boolean('all', None, _('list all available information'),
		None, (O_NOCONFIG, O_NONINTERACTIVE), ['all', 'a']),
	String('plugins', '', _('list plugins in a particular collection'),
	       None, (O_NOCONFIG, O_NONINTERACTIVE, O_MULTIPLE), ['plugins', 'p']),
	]
    
    def __init__(self):
	Application.__init__(self)
	self.config_path = 'Pyrite::Info'

    def info_header(self):
	print _("Pyrite Version  : %s") % Pyrite.version
	print _("Sulfur Version  : %s") % Sulfur.version
	print

    def info_python(self):
	print _("Python Platform : %s") % sys.platform
	print _("Python Version  : %s") % sys.version
	
    def info_defaults(self):
	print
	print _("Data Directory  : %s") % self.data_directory
	print _("Port            : %s") % self.port
	print _("User Name       : %s") % self.default_user
	print _("User ID         : %s") % self.default_uid
	if self.plugin_module_path:
	    print
	    p = self.plugin_module_path[0]
	    print _("Plugin Path     : %s") % (p and p or _("(current package)"))
	    for p in self.plugin_module_path[1:]:
		print   "                : %s" % (p and p or _("(current package)"))

    def info_state(self):
	print
	print _("Current User    : %s") % self.user
	print _("Current User ID : %s") % self.uid
	print _("Sync ID         : %s") % self.sync_id
	
    def info_plugins(self, collection, title=None, verbose=0):
	inf = self.list_plugin_info(collection)
	ky = inf.keys()
	ky.sort()
	if not title: title = _("Plugins in collection '%s':") % collection
	print title
	print
	print _("Name            Version  Description")
	print _("----            -------  -----------")
	for k in ky:
	    i = inf[k]
	    print _("%-15s %-8s %s") % (k[:15], i['version'][:8],
					string.split(i['description'],'\n')[0][:54])
	print
	
    def run(self, argv):
	if self.get_option('help'): return

	if not self.get_option('plugins'):
	    self.info_header()
	    self.info_python()
	    self.info_defaults()
	    self.info_state()
	    print
	    
	    if self.get_option('all'):
		print
		self.info_plugins('Connector', _("Connectors:"))
		print
		self.info_plugins('Conduit', _("Conduits:"))
		#self.info_plugins('Filter', _("Filters:"))
		print
		self.info_plugins('Store', _("Stores:"))
		print
		self.info_plugins('Application', _("Applications:"))
		
	else:
	    for p in self.get_option('plugins'):
		print
		self.info_plugins(p)
		
	
if __name__ == '__main__':
    a = App()
    a()
    
