#
#  $Id: generic.py,v 1.2 1999/08/09 21:59:14 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""Pyrite generic platform support.
"""

__version__ = '$Id: generic.py,v 1.2 1999/08/09 21:59:14 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'

import string

def protect_name(s):
    s = string.replace(s, '=', '=3D')
    s = string.replace(s, '/', '=2F')
    s = string.replace(s, '\n', '=0A')
    s = string.replace(s, '\r', '=0D')
    return s

def unprotect_name(s):
    s = string.replace(s, '=2F', '/')
    s = string.replace(s, '=0A', '\n')
    s = string.replace(s, '=0D', '\r')
    s = string.replace(s, '=3D', '=')
    return s

