#
#  $Id$
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""
"""

__version__ = '$Id$'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'


import Pyrite
import Pyrite.Connector, Pyrite.Store
from Pyrite import Blocks
import string, struct

from Pyrite import _, FLD_STRING, FLD_INT, FLD_TIME_T, FLD_UNKNOWN

class TSConnector(Pyrite.Connector.Connector):
    name = 'Timesheet'
    version = Pyrite.version
    author = Pyrite.author
    url = ''
    description = _("Timesheet by Stuart Nicholson")

    def __init__(self, *a, **kw):
	apply(Pyrite.Connector.Connector.__init__, (self,)+a, kw)
	self.default_name = 'TimesheetDB'
	self.default_class = Database
	self.default_creator = 'TiSh'
	self.default_type = 'data'

    def classify(self, info={}):
	if info.get('creator') == 'TiSh' and info.get('type') == 'data':
	    return Database

# Record 0: preferences
class PrefRecord(Blocks.Record):
    fields = {}
    def unpack(self, raw):
	self.raw = raw
    
    def pack(self):
	return self.raw


# Records 1-3 (one each for clients, projects, task)
class CatRecord(Blocks.Record):
    fields = {}
    def unpack(self, raw):
	self.raw = raw
    
    def pack(self):
	return self.raw

# regular records ... timesheet mixes day records and time records,
# a day record is like a header for the time records that refer to
# that day.  this will probably require using the size to determine
# what kind of record something is.  aaargh.
class DayRecord(Blocks.Record):
    fields = { 'num_entries': (FLD_INT, 0),
	       'date': (FLD_TIME_T, (0,0,0,0,0,0,0,0,0)),
	       }
    

class TimeRecord(Blocks.Record):
    pass


