#
#  $Id: Memo.py,v 1.2 1999/12/11 12:35:11 rob Exp $
#
#  Copyright 1998-1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""Memo Pad.
"""

__version__ = '$Id: Memo.py,v 1.2 1999/12/11 12:35:11 rob Exp $'

__copyright__ = 'Copyright 1998-1999 Rob Tillotson <robt@debian.org>'

import Pyrite
import Pyrite.Connector
from Pyrite import FLD_STRING, FLD_BOOLEAN
import struct, string
from Pyrite import Blocks, _

class Connector(Pyrite.Connector.Connector):
    name = 'Memo'
    version = Pyrite.version
    author = Pyrite.author
    url = ''
    description = _("The built in memo pad.")

    def __init__(self, *a, **kw):
	apply(Pyrite.Connector.Connector.__init__, (self,)+a, kw)
	self.default_name = 'MemoDB'
	self.default_class = Database
	self.default_creator = 'memo'
	self.default_type = 'DATA'
	
    def classify(self, info={}):
	if info.get('type') == 'DATA' and info.get('creator') == 'memo':
	    return Database
	
class Record(Blocks.Record):
    def __init__(self, *a, **kw):
	self.fields = {'text': (FLD_STRING, '')}
	apply(Blocks.Record.__init__, (self,)+a, kw)

    def unpack(self, raw):
	self.raw = raw
	self.data['text'] = string.split(raw,'\0')[0]

    def pack(self):
	self.raw = self.data['text']+'\0'
	return self.raw

class AppBlock(Blocks.CategoryAppBlock):
    def __init__(self, *a, **kw):
	self.fields = { 'sortByAlpha': (FLD_BOOLEAN, 0) }
	apply(Blocks.CategoryAppBlock.__init__, (self,)+a, kw)

    def unpack(self, raw):
	self.raw = raw
	raw = Blocks.CategoryAppBlock.unpack(self, raw)
	if len(raw) < 4: self.data['sortByAlpha'] = 0
	else:
	    self.data['sortByAlpha'] = int(struct.unpack('>B', raw[2])[0])
	
    def pack(self):
	self.raw = Blocks.CategoryAppBlock.pack(self)
	self.raw = self.raw + '\0\0' + chr(self.data['sortByAlpha']) + '\0'
	return self.raw

class Database(Pyrite.Database):
    def __init__(self, *a, **kw):
	apply(Pyrite.Database.__init__, (self,)+a, kw)
	self.record_class = Record
	self.appblock_class = AppBlock


