# This script will be called from the 'Setup' utility
#

use Carp;

sub complain
{
    my ($mod, $err) = @_;

    print qq|
You do not have the correct binary of the $mod module
installed in either your PilotManager distribution or your
perl installation.  SyncPlan will not be able to run until
this is fixed.

Please read README.porting for information about how to
download and install this module.

Error details:
-----------------------------------------------------------------------------
$err-----------------------------------------------------------------------------

|;
    croak("FAIL");
}

eval "use IO::Socket";
&complain("IO::Socket", $@) if ($@);

eval "use IO::Select";
&complain("IO::Select", $@) if ($@);

eval "use MD5";
&complain("MD5", $@) if ($@);

print qq|
All required modules are installed properly on your system,
so SyncPlan will run.

|;

