#
#  $Id: Application.py,v 1.4 1999/12/16 10:32:46 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU Library General Public License, version 2,
#  as published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
#
#  You should have received a copy of the GNU Library General Public License
#  along with this program; if not, write the Free Software Foundation,
#  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
#
"""
"""

__version__ = '$Id: Application.py,v 1.4 1999/12/16 10:32:46 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'


from Pyrite.Application import Application, PyriteCLIAppContext
import Sulfur.AppContext

# standard command line arguments:
#
# -h, --help            get help
#
# -t, --title STR       title of the document (overriding doc-specified one)
# -b, --backup          set backup bit
# -c, --category NUM    set category number (0-15)
# --creator ID          creator
# --type ID             type
#
# -I PLUGIN             input format
# -O PLUGIN             output format
#
# --immediate           install directly on a connected pilot
# --install             spool for installation
# -U USER               specify the user name for install spooling
#   ... default is to just make a .pdb/.prc file in current dir.
#

from Sulfur.Options import Boolean, String, Integer
from Sulfur.Options import O_NOCONFIG, O_NONINTERACTIVE

import sys, string

class DTKApp(Application):
    name = 'Doc Toolkit'
    version = '1.1.1'
    author = 'Rob Tillotson <robt@debian.org>'
    url = ''
    description = 'Create Doc-format e-texts.'
    auto_cmd_line = 0
    options = [
	Boolean('list-formats', None, 'list available formats',
		None, (O_NOCONFIG, O_NONINTERACTIVE), ['list-formats', 'l']),
	String('title', None, 'the document title', None, None, ['title','t']),
	Boolean('backup', 0, 'set the backup bit in the output document',
		None, None, ['backup', 'b']),
	Integer('category', 0, 'the category of the document', None, None,
		['category', 'c']),
	String('creator', 'REAd', 'the document creator ID', None, None,
	       ['creator', 'C']),
	String('type', 'TEXt', 'the document type', None, None, ['type', 'T']),
	String('input-format', 'Raw', 'the input format', None, None,
	       ['input-format','I']),
	String('output-format', 'Basic', 'the output format', None, None,
	       ['output-format', 'O']),
	Boolean('sync', 0, 'install directly on a connected handheld', None, None,
		['sync', 'S']),
	Boolean('install', 0, 'install using Pyrite', None, None, ['install','i']),
	String('user', None, 'user name to use for Pyrite installation',
	       None, None, ['user','U']),
	]
    auto_cmd_line = 0
    
    def __init__(self, *a, **kw):
	Application.__init__(self)
	self.plugin_module_path.insert(0, '')

	self.config_path = 'DocToolkit'
	
    def run(self, argv):
	# first, a little hack to find the output and input formats
	#	if '-I' in argv: itype = argv[argv.index('-I')+1]
	#	else: itype = 'Raw'

	#	if '-O' in argv: otype = argv[argv.index('-O')+1]
	#	else: otype = 'Basic'

	#	iplug = self.get_plugin('DTKInput', itype)
	#	oplug = self.get_plugin('DTKOutput', otype)
	#
	#	argv = self.process_options(argv, [iplug, oplug])
	
	#	if self.get_option('help'): return
	
	if self.get_option('input-format'):
	    iplug = self.get_plugin('DTKInput', self.get_option('input-format'))
	else:
	    iplug = self.get_plugin('DTKInput', 'Raw')
	    
	if self.get_option('output-format'):
	    oplug = self.get_plugin('DTKOutput', self.get_option('output-format'))
	else:
	    oplug = self.get_plugin('DTKOutput', 'Basic')
	    
	if self.get_option('list-formats'):
	    sys.stdout.write('    %-15s %-10s %-45s\n' % ('Name','Version',
							  'Description'))
	    sys.stdout.write('    %-15s %-10s %-45s\n' % ('----','-------',
							  '-----------'))
	    l = self.list_plugin_info('DTKInput')
	    keys = l.keys()
	    keys.sort()
	    for k in keys:
		v = l[k]
		if not v.get('name'): continue
		sys.stdout.write('In  %-15s %-10s %-45s\n' % \
				 (k[:10], v['version'][:10],
				  string.split(v['description'],'\n')[0][:45]))

	    sys.stdout.write('\n')
	    l = self.list_plugin_info('DTKOutput')
	    keys = l.keys()
	    keys.sort()
	    for k in keys:
		v = l[k]
		if not v.get('name'): continue
		sys.stdout.write('Out %-15s %-10s %-45s\n' % \
				 (k[:10], v['version'][:10],
				  string.split(v['description'],'\n')[0][:45]))
	    return
		
	
	# find the store we will put the document in.
	if self.get_option('sync'):
	    store = self.connect()
	elif self.get_option('install'):
	    if self.get_option('user'):
		raise RuntimeError, 'sorry, user specification not implemented yet.'
	    store = self.user_directory('install')
	else:
	    p = self.get_plugin('Store','Directory')
	    store = p('.')

	# assume that all remaining arguments are files.  there should be
	# some way in the future for input plugins to bypass this...

	for fn in argv:
	    print "Converting %s..." % fn

	    f, bn = iplug.open(fn)
	    w = oplug.open(store, bn,
			   self.get_option('title'),
			   self.get_option('creator'),
			   self.get_option('type'),
			   self.get_option('backup'),
			   self.get_option('category'))
	    
	    # output preprocessing can be done in oplug.open
	    # input preprocessing can be done in iplug.open or iplug.convert

	    iplug.convert(f, w)

	    # input postprocessing can be done in iplug.convert
	    # put output postprocessing hook here
	    
	    w.close()
	    f.close()
	    

class DTKCLIStartup(Sulfur.AppContext.CLIStartup):
    def get_initial_args(self):
	a = sys.argv[1:]
	if '-I' in a: itype = a[a.index('-I')+1]
	else: itype = 'Raw'
	if '-O' in a: otype = a[a.index('-O')+1]
	else: otype = 'Basic'

	iplug = self.context.get_plugin('DTKInput', itype)
	oplug = self.context.get_plugin('DTKOutput', otype)

	self.context.preloaded_plugins.append(iplug)
	self.context.preloaded_plugins.append(oplug)

	return Sulfur.AppContext.CLIStartup.get_initial_args(self)

class DTKPluginManager(Sulfur.AppContext.StandardPluginManager):
    def start(self, *a, **kw):
	apply(Sulfur.AppContext.StandardPluginManager.start, (self,)+a, kw)

	if not self.product_installed('Doc Toolkit'):
	    self.product_install('DocToolkit')
    
class DTKCLIAppContext(PyriteCLIAppContext):
    def __init__(self, *a, **kw):
	apply(PyriteCLIAppContext.__init__, (self,)+a, kw)
	self.startup_manager = DTKCLIStartup()
	self.plugin_manager = DTKPluginManager()
	
