#ifndef _SLTCP_H_LOADED_
#define _SLTCP_H_LOADED_
/* Copyright (c) 1998 John E. Davis (davis@space.mit.edu)
 *
 * This file is part of slrn.
 *
 * Slrn is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * Slrn is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Slrn; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place - Suite 330, 
 * Boston, MA  02111-1307, USA.
 */


#if !defined(VMS) || defined(UCX)

#include <stdarg.h>

typedef struct 
{
   int tcp_fd;
#define SLTCP_EOF_FLAG	0x1
   unsigned int tcp_flags;
   unsigned char *tcp_write_ptr;
   unsigned char *tcp_write_ptr_min;
   unsigned char *tcp_read_ptr_max;
   unsigned char *tcp_read_ptr;
#define SLTCP_BUF_SIZE 8192
   unsigned char tcp_read_buf [SLTCP_BUF_SIZE];
   unsigned char tcp_write_buf [SLTCP_BUF_SIZE];
   unsigned long bytes_out;
   unsigned long bytes_in;
}
SLTCP_Type;

extern int sltcp_close_socket (SLTCP_Type *);
extern SLTCP_Type *sltcp_open_connection (char *, int);
extern int sltcp_close (SLTCP_Type *);
extern unsigned int sltcp_read (SLTCP_Type *, char *, unsigned int);
extern unsigned int sltcp_write (SLTCP_Type *, char *, unsigned int);
extern int sltcp_flush_output (SLTCP_Type *);
extern int sltcp_map_service_to_port (char *);
extern int (*SLTCP_Interrupt_Hook) (void);

extern int sltcp_fputs (SLTCP_Type *, char *);
extern int sltcp_vfprintf (SLTCP_Type *, char *, va_list);
extern int sltcp_fgets (SLTCP_Type *, char *, unsigned int);

extern int sltcp_open_sltcp (void);
extern int sltcp_close_sltcp (void);

#endif

#endif
