#include "slrnfeat.h"

#ifdef KANJI
/* 
 * This code convert routine is originated by Makoto Kikutani,
 * and exhanced by Uichi Katsuta.
 */
#include <stdio.h>
#include <string.h>
#include <slang.h>
#include "khenkan.h"
#include "misc.h"
#include "util.h"

/* ¾Υ⥸塼ܸ쥳ɤѴ˰Ū˻Ȥΰ */
/* Υ⥸塼ǤϻȤäƤϤʤ */
unsigned char jtmp_str[JTMP_LEN + 1];

/* X0201 / X0208 conversion */

/* X0201 kana conversion table (0x90 - 0xdf)*/
/* upper = ((cv[ch - 0x90] & 0x80) >> 5) + 0x21 */
/* lower = (cv[ch - 0x90] & 0x7f) + 0x21 */
static unsigned char cv[]= {
  0x00,0x02,0x35,0x36, 0x01,0x05,0xd1,0x80,
  0x82,0x84,0x86,0x88, 0xc2,0xc4,0xc6,0xa2,
  0x1b,0x81,0x83,0x85, 0x87,0x89,0x8a,0x8c,
  0x8e,0x90,0x92,0x94, 0x96,0x98,0x9a,0x9c,
  0x9e,0xa0,0xa3,0xa5, 0xa7,0xa9,0xaa,0xab,
  0xac,0xad,0xae,0xb1, 0xb4,0xb7,0xba,0xbd,
  0xbe,0xbf,0xc0,0xc1, 0xc3,0xc5,0xc7,0xc8,
  0xc9,0xca,0xcb,0xcc, 0xce,0xd2,0x0a,0x2c
};

static int Zenkaku1; /* Ѵʸξ 1 Х */
static int Zenkaku2; /* Ѵʸβ 1 Х */

/* Ⱦѥ(1 or 2 ʸ) -> ѥ(1 ʸ)
 *  s   : ϤʸؤΥݥ(EUC ξ SS2 Ϥޤ)
 *  return: ѤѴȾѥʤʸ(EUC ξ SS2 ޤ)
 *    0: ȾѥʤǤϤʤä
 *    1: ϤʸѥʤѴ(EUC ξ 2)
 *    2: ȾޤơϤʸѤѴ(EUC ξ 4)
 */
static int slrn_han2zen(unsigned char *s)
{
  int ch, d1, d2, result, euc = 0;

  if ((*s | 0x80) == SS2) {
    s++;
    euc = 1;
  }
  ch = (*s++ & 0x7f) - 0x20;
  if (ch < 0 || ch >= 0x40) {
    return (0);
  }
  ch = cv[ch];
  d1 = ((ch & 0x80) >> 5) + 0x21;
  d2 = (ch & 0x7f) + 0x21;
  result = 1;

  if (d1 == 0x25
      && ((d2 >= 0x2b && d2 <= 0x48) || (d2 >= 0x4f && d2 <= 0x5b))) {
    ch = *s++;
    if (euc) {
      if ((ch | 0x80) == SS2) {
	ch = *s++;
      } else {
	ch = 0;
      }
    }
    ch &= 0x7f;
    if (ch == 0x5e) { /*  */
      d2++;
      result = 2;
    } else if (ch == 0x5f && d2 >= 0x4f) { /* Ⱦ */
      d2 += 2;
      result = 2;
    }
  }
  Zenkaku1 = d1;
  Zenkaku2 = d2;
  return (result << euc);
}

/*
 * EUC -> JIS  
 *     ϤJISä餽Τޤ̤(ʤäƤ롩)
 *     ڤƤ⤽Τޤ(ASCII ᤵʤ)
 *     ȾѥʤѤľ
 *  return 0: success
 *         1: ڤ줿
 */
#define TO_ASCII(p) (*(p)++ = ESC, *(p)++ = '(', *(p)++ = 'B')
#define TO_JIS208(p) (*(p)++ = ESC, *(p)++ = '$', *(p)++ = 'B')
#define TO_JIS201(p) (*(p)++ = ESC, *(p)++ = '(', *(p)++ = 'I')

int euc2jis(unsigned char *d, unsigned char *s, int dlen)
{
  int k = 0, ch;

  while(dlen > 0) { /* ASCII character or JIS encoding */
    ch = *s++;
    if (ch & 0x80) {
      if (k == 0) {
	dlen -= 3;
	if (dlen < 0) break;
	TO_JIS208(d);
	k = 1;
      }
      if (ch != SS2) {
	dlen--;
	*d++ = ch & 0x7f;
	ch = *s++;
      } else {  /* ȾѥʡѤѴ */
	s--;
	s += slrn_han2zen(s);
	dlen--;
	*d++ = Zenkaku1;
	ch = Zenkaku2;
      }
      if (dlen <= 0) break;
    } else if (k == 1) {
      dlen -= 3;
      if (dlen < 0) break;
      TO_ASCII(d);
      k = 0;
    }
    if (ch == '\0') break;
    dlen--;
    *d++ = ch & 0x7f;
  }
  *d = '\0';
  if (dlen < 0) {
    return 1;
  } else {
    return 0;
  }
}

/*
 * JIS(, EUC) -> EUC
 *  d: Ѵʸ
 *  s: Ѵʸ
 *  dlen: ѴΥХåեĹ(Ǹ '\0' ϴޤޤʤ)
 *
 *  return
 *  0: ASCII
 *  1: JIS
 *  2: EUC
 *   ʲѴ
 *  3: SJIS Τʤ
 *  4: 7bit  2 Хʸڤ줿ޤ JIS νλ󥹤̵
 *  5: 8bit  SJIS Ǥ EUC Ǥʤ
 */
typedef enum {ASC, JISX0208, JISX0201, OTHER} Kanji_Type;

int jis2euc(unsigned char *d, unsigned char *s, int dlen)
{
  unsigned char *seq;
  int c1, c2, ctrl = 0, hibit = 0;
  Kanji_Type kanji_mode = ASC;

  while((c1 = *s++) && dlen > 0) {
    if (c1 & 0x80) { /* 8bit code ??? */ /* ޤEUC */
      /* JIS-X0208 ؤΥ󥹤¸ߤ 8bit ʸ SJIS
	 ȸʤ */
      seq = s;
      while(*seq++ != '\0' && ctrl == 0) {
	if (*seq == ESC && *(seq + 1) == '('
	    && (*(seq + 2) == '@' || *(seq + 2) == 'B')) ctrl++;
      }
      if (ctrl == 0) {
	hibit++;
	c2 = *s;
	if (c1 == 0x92 && IS_EUC1(c2) && IS_EUC2(*(s+1))) {
	  /* Mule  */
	  c1 = c2;
	  s++;
	  c2 = *s;
	}
	if (IS_EUC1(c1) && IS_EUC2(c2)) { /* EUC 餷 */
	  kanji_mode = ASC;
	  dlen--;
	  *d++ = c1;
	  c1 = c2;
	  s++;
	} else if (c1 == SS2 && IS_SJISH(c2)) { /* EUC Ⱦѥ */
	  if ((c2 = slrn_han2zen(s - 1)) > 0) {
	    s += c2 - 1;
	    dlen -= 2;
	    *d++ = Zenkaku1 | 0x80;
	    *d++ = Zenkaku2 | 0x80;
	  }
	  continue;
	} else if (IS_SJISH(c1) || (IS_SJIS1(c1) && IS_SJIS2(c2))) {
	  /* ʤƤäSJIS餷 */
	  *d = 0; /*  */
	  return (3);
	} else { /* ܸǤϤʤꤢĤʸʣ̤ */
	  strcpy((char *)d, (char *)s);
	  return (5);
	}
      } else {
	unsigned char str[3];  /* SJIS ȤߤʤѴ */

	str[0] = c1;
	if (*s == '\0' || *s == ESC || IS_SJISH(c1)) {
	  str[1] = '\0';
	} else {
	  str[1] = *s++;
	  str[2] = 0;
	}
	if (sjis2euc(d, str, dlen) == 0) {
	  while(*d != '\0') d++;
	}
	continue;
      }
    } else {
      switch(c1) {
      case ESC:
	ctrl++;
	c1 = *s++;
	if (c1 == '$') {
	  c1 = *s++;
	  if (c1 == '(') c1 = *s++;
	  if (c1 == '@' || c1 == 'B') {
	    kanji_mode = JISX0208;
	  } else { /* ¾ʸåȡ'?'֤ */
	    kanji_mode = OTHER;
	  }
	} else if (c1 == '(') {
	  c1 = *s++;
	  if (c1 == 'B' || c1 == 'H' || c1 == 'J' ) {
	    kanji_mode = ASC;
	  } else if (c1 == 'I') { /* X0201 */
	    kanji_mode = JISX0201;
	  } else { /* ¾ʸåȡ'?'֤ */
	    kanji_mode = OTHER;
	  }
	} else {
	  s--;  /*  ESC̵뤹 */
	}
	continue;
	/* not break */
      case SO:
	ctrl++;
	seq = s;
	while((c1 = *seq++) != '\0' && c1 != SI);
	if (c1 == '\0' && (c2 = slrn_han2zen(s - 1)) > 0) {
	  s += c2 - 1;             /* SI ʤХ󥰥륷եȤȸʤ */
	  dlen -= 2;
	  *d++ = Zenkaku1 | 0x80;
	  *d++ = Zenkaku2 | 0x80;
	} else {
	  kanji_mode = JISX0201;
	}
	continue;
	/* not break */
      case SI:
	ctrl++;
	kanji_mode = ASC;
	continue;
	/* not break */
      default:
	if (c1 <= ' ') {
	  *d++ = c1;
	  dlen--;
	  continue;
	}
	/* not break */
      }
    }
    switch(kanji_mode) {
    case OTHER:
      c1 = '?';
      /*FALLTHROUGH*/
    case ASC: /* ޤ EUC */
      *d++ = c1;
      dlen--;
      continue;
    case JISX0201:
      s--;
      c1 = slrn_han2zen(s); /* X0208Ѵ(Ⱦѥʢѥ) */
      if (c1 == 0) {  /* ȾѥʤǤʤ̵뤹롣 */
	s++;
	continue;
      } else {
	s += c1;
      }
      c1 = Zenkaku1;
      c2 = Zenkaku2;
      break;
    default:
      c2 = *s++;
      if (c2 == 0x01) { /* Ƕ Mozilla 4.04 [en] (Win95; I) ΥХ */
	c1++;           /* ܤʸФ */
	c2 += 0x21;
      }
    }
    dlen -= 2;
    if (dlen < 0 || c2 == 0 || c2 == ESC) break;
    *d++ = c1 | 0x80;
    *d++ = c2 | 0x80;
  }
  *d = '\0';
  if ((kanji_mode != ASC && c2 == 0) || kanji_mode == JISX0208) {
    return (4);
  } else if (ctrl) {
    return (1);
  } else if (hibit) {
    return (2);
  }
  return (0);
}

/*
 * SJIS -> EUC 
 * ˤSJISꤲƤͤ⤤ΤǤʤ
 *  return 0: success
 *         1: ڤ줿
 *         2: SJIS ǤϤʤ (̤)
 */
int sjis2euc(unsigned char *d, unsigned char *s, int dlen)
{
  int upper, lower, jisx0201_mode = 0;

  while((upper = *s++) != 0 && dlen > 0) {
    if ((upper & 0x80) == 0) { /* ASCII */
      /* ʤ SJIS  JISX0201 ؤΥ󥹤¸ߤ뤳Ȥ */
      if (upper != ESC) {
	*d++ = upper;
	dlen--;
	continue;
      } else if (*s == '(') {
	s++;
	if (*s == 'I') {
	  jisx0201_mode = 1;
	} else {
	  jisx0201_mode = 0;
	}
	upper = *(s + 1);
	s += 2;
      }
    }
    if ((upper >= 0xa0 && upper < 0xe0) || jisx0201_mode) {
      s--;  /* Ⱦѥ */
      s += slrn_han2zen(s);
      upper = Zenkaku1 | 0x80;
      lower = Zenkaku2 | 0x80;
    } else { /*  */
      lower = *s++;
      if (!IS_SJIS2(lower) || upper >= 0xf0) { /* ڤ줿 */
	if (lower == '\0') { /* ޤ˹Ԥޤ֤ʤɤ 2byte ʸ */
	  break;             /* ֤ byte ڤƤ뵭롣*/
	} else {
	  return (1);
	}
      }
      if (upper >= 0xe0) {
	upper -= 0x70;
      } else {
	upper -= 0x30;
      }
      upper <<= 1;
      if (lower >= 0x9f) {
	lower += 2;
      } else {
	upper--;
	if (lower & 0x80) {
	  lower += 0x60;
	} else {
	  lower += 0x61;
	}
      }
    }
    dlen -= 2;
    if (dlen < 0) break;
    *d++ = upper;
    *d++ = lower;
  }
  *d = '\0';

  return 0;
}

/*
 * EUC -> SJIS 
 * 顼åϤƤʤ
 *  return 0: success
 */
int euc2sjis(unsigned char *d, unsigned char *s, int dlen)
{
  int ch, ch2;

  while((ch = *s++) != 0 && dlen > 0) {
    if ((ch & 0x80) == 0) { /* ASCII */
      *d++ = ch;
      dlen--;
      continue;
    }
    if (ch == SS2) {
      ch2 = slrn_han2zen(s - 1);
      if (ch2 != 0) {
	s += ch2 - 1;
	ch = Zenkaku1 | 0x80;
	ch2 = Zenkaku2 | 0x80;
      }
    } else {
      ch2 = *s++;
    }
    if (ch & 1) {
      ch2 -= 0x60;
      if ((ch2 & 0x80) == 0) {
	ch2--;
      }
    } else {
      ch2 -= 2;
    }
    ch++;
    ch >>= 1;
    ch += 0x30;
    if (ch > 0x9f) {
      ch += 0x40;
    }
    dlen -= 2;
    *d++ = ch;
    *d++ = ch2;
  }
  *d = '\0';
  return (0);
}

/*
 * JIS -> internal code(EUC)
 * return (ϥɤ)
 * 0: ASCII
 * 1: JIS
 * 2: EUC (¾ 8bit ϥɤΤʤ)
 * 3: SJIS
 * 4: SJIS Ȼפ뤬ǤʤΤʤ
 * 5: 8bit  SJIS Ǥ EUC Ǥʤ
 */
int jis2int(unsigned char *d, unsigned char *s, int dlen)
{
  unsigned char ch, *p = s;
  int hibit = 0;

  /*  EUC Ѵ */
  switch (jis2euc(d, s, dlen)) {
  case 0: /* ASCII */
    return (0);
  case 1: /* JIS */
  case 4: /* JIS ڤ줿*/
    return (1);
  case 2: /* EUC */
    return (2);
  case 3: /* SJIS? */
    /* SJISäSJIS->EUC */
    if (sjis2euc(d, s, dlen) != 0) return (5);
    /* 8bit ʸ٤ ASCII ¿ܸǤʤȤߤʤ */
    /* 8bit ʸ 1 Ĥ 3 Ϣ³Ƥ SJIS Ȥߤʤ */
    /* 0x80 - 0x9f ˤ ISO-8859-X ǤϤʤ(Ȥä SJIS ǤȤ
       ʤ SJIS ǤȤȤˤ) */
    /* ⤦äΤȽ꤬褦ˡɤɬ!! */
    while((ch = *p++) != 0) {
      if (ch & 0x80) {
	hibit++;
	if (ch < 0xa0 || (ch != *p && ch != *(p + 1)
	    && (*(p + 1) & 0x80) && (*(p + 3) & 0x80))) return (3);
      }
    }
    if (hibit * 9 > strlen((char *)s)) return (3);
    return (4);
  }
  return (5);
}

/*
 * universal code covert routine
 */
static int convcode(unsigned char *d, unsigned char *s, int dlen, int code)
{
  static unsigned char jstr[JTMP_LEN + 1];
  int ret;

  ret = jis2euc(jstr, s, dlen);
  switch(code) {
  case JIS:
    if (ret <= 1 || ret >= 4) {
      strcpy((char *)d, (char *)s);
      return (0);
    } else if (ret == 3) {
      (void)sjis2euc(jstr, s, dlen);
    }
    return (euc2jis(d, jstr, dlen));
  case EUC:
    if (ret == 0 || ret == 2 || ret >= 4) {
      strcpy((char *)d, (char *)s);
      return (0);
    } else if (ret == 1) {
      strcpy((char *)d, (char *)jstr);
      return (0);
    } else {
      return (sjis2euc(d, s, dlen));
    }
  case SJIS:
    if (ret == 0 || ret >= 3) {
      strcpy((char *)d, (char *)s);
      return (0);
    } else {
      return (euc2sjis(d, jstr, dlen));
    }
  }
  return (0);
}

/* ե code ǻꤵ줿ɤѴ */
int slrn_conv_file(char *file, int code)
{
  static unsigned char jstr[JTMP_LEN + 1];
  static char line[1024], tmpfile[256 + 2 * SLRN_MAX_PATH_LEN];
  FILE *origfp, *tmpfp;
  int ch;
  unsigned int len;

  origfp = fopen(file, "r");
  tmpfp = slrn_open_tmpfile (tmpfile, "w");
  if (origfp == NULL || tmpfp == NULL) {
    slrn_error("File Open Error.");
    return (-1);
  }
  while (EOF != (ch = getc(origfp))) {
    if (EOF == putc(ch, tmpfp)) {
      slrn_error("Write Error.");
      return (-1);
    }
  }
  slrn_fclose (tmpfp);
  slrn_fclose (origfp);
     
  origfp = fopen(file, "w");
  tmpfp = fopen(tmpfile, "r");
  while (fgets (line, sizeof(line), tmpfp) != NULL) {
    len = strlen (line);       
    if (len == 0) continue;
    len--;

    if (line [len] == '\n') line [len] = '\0';
    (void)convcode(jstr, (unsigned char *)line, JTMP_LEN, code);
    fputs((char *)jstr, origfp);
    putc('\n', origfp);
  }
  slrn_fclose (tmpfp);
  slrn_fclose (origfp);

  slrn_delete_file(tmpfile);
  return (0);
}

/* ʸ code ǻꤵ줿ɤѴ */
void slrn_conv_string(char *line, int code)
{
  static unsigned char jstr[JTMP_LEN];

  (void)convcode(jstr, (unsigned char *)line, JTMP_LEN, code);
  (void)strcpy(line, (char *)jstr);
}

#define match_2byte(c1, c2) ((((c1) > '\040' && (c1) < '\050') \
			      || ((c1) > '\057' && (c1) < '\165')) \
			     && (c2) > '\040' && (c2) < '\177')

#define match_kin(c1, c2) ((c1) == '$' \
			   && ((c2) == '@' || (c2) == 'B'))

#define match_kout(c1, c2) ((c1) == '(' \
			    && ((c2) == 'J' || (c2) == 'B'))

/* ESC  JIS encoding  EUC Ѵ롣Ѵ */
/* 1 ֤*/
int recover_jis(unsigned char *to, unsigned char *from, int max)
{
  static unsigned char jtmp[JTMP_LEN];
  unsigned char *orig_ptr = from, *buf = jtmp, c1, c2;
  int len, eflag = 0;

  while(*from != '\0' && from - orig_ptr < JTMP_LEN) {
    if (match_kin(*from, *(from + 1))){
      if (from > orig_ptr && *(from - 1) == '\033') {
	eflag = 1;
      }
      len = 2;
      while(*(from + len) != '\0' && from - orig_ptr < max - len) {
	c1 = *(from + len);
	c2 = *(from + len + 1);
	if (match_2byte(c1, c2)) { /* 2byte charcter */
	  len += 2;
	} else if (c1 == '\040') {  /* space */
	  len++;
	} else if (c1 == '\033') {
	  if (match_kin(c2, *(from + len + 2)) && eflag == 0) {
	    break;  /* real kin sequence */
	  }
	  len++; /* only a escape character */
	} else {  /* not a mutibyte character sequence */
	  if (match_kout(c1, c2)  /* kout sequence */
	      && (eflag == 0 || *(from + len - 1) == '\033')) {
	    if (eflag == 0) {
	      *buf++ = '\033';
	    }
	    while(len > 0) {
	      *buf++ = *from++;
	      len--;
	    }
	    if (*(from - 1) != '\033') {
	      *buf++ = '\033';
	    }
	  }
	  break;
	}
      }
      eflag = 0;
    }
    *buf = *from;
    from++;
    buf++;
  }
  *buf = '\0';
  return (jis2int(to, jtmp, max));
}

/* koi8-r  ISO-8859-5 Ѵ */
static unsigned char koi8_table[] = {
  32, 32, 32, 0xf1, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 0xa1, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32,
  0xee, 0xd0, 0xd1, 0xe6, 0xd4, 0xd5, 0xe4, 0xd3,
  0xe5, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde,
  0xdf, 0xef, 0xe0, 0xe1, 0xe2, 0xe3, 0xd6, 0xd2,
  0xec, 0xeb, 0xd7, 0xe8, 0xed, 0xe9, 0xe7, 0xea,
  0xce, 0xb0, 0xb1, 0xc6, 0xb4, 0xb5, 0xc4, 0xb3,
  0xc5, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe,
  0xbf, 0xcf, 0xc0, 0xc1, 0xc2, 0xc3, 0xb6, 0xb2,
  0xcc, 0xcb, 0xb7, 0xc8, 0xcd, 0xc9, 0xc7, 0xca
};

void slrn_convert_koi8_r2iso8859_5(unsigned char *s)
{
  while(*s != '\0') {
    if (*s >= 0xa0) {
      *s = koi8_table[*s - 0xa0];
    }
    s++;
  }
}

/* UCS2  JISX0201JISX0208(Ҥ餬ʡʤΤ)ޤ ISO-8859-1
   Ѵ(ʳδѴϤǤʤ) */
static unsigned char u3000[] = {  /* 3000 - 3015 */
  0x21, 0x21, 0x21, 0x22, 0x21, 0x23, 0x21, 0x37,
  0x00, 0x00, 0x21, 0x39, 0x21, 0x3A, 0x21, 0x3B,
  0x21, 0x52, 0x21, 0x53, 0x21, 0x54, 0x21, 0x55,
  0x21, 0x56, 0x21, 0x57, 0x21, 0x58, 0x21, 0x59,
  0x21, 0x5A, 0x21, 0x5B, 0x22, 0x29, 0x22, 0x2E,
  0x21, 0x4C, 0x21, 0x4D
};

static unsigned char u309b[] = { /* 309B - 309E */
  0x21, 0x2B, 0x21, 0x2C, 0x21, 0x35, 0x21, 0x36
};

static unsigned char u30fb[] = { /* 30FB - 30FE */
  0x21, 0x26, 0x21, 0x3C, 0x21, 0x33, 0x21, 0x34
};

static unsigned char uff01[] = { /* FF01 - FF0F */
  0x21, 0x2A, 0x00, 0x00, 0x21, 0x74, 0x21, 0x70,
  0x21, 0x73, 0x21, 0x75, 0x00, 0x00, 0x21, 0x4A,
  0x21, 0x4B, 0x21, 0x76, 0x21, 0x5C, 0x21, 0x24,
  0x21, 0x5D, 0x21, 0x25, 0x21, 0x3F
};

static unsigned char uff1a[] = { /* FF1A - FF20 */
  0x21, 0x27, 0x21, 0x28, 0x21, 0x63, 0x21, 0x61,
  0x21, 0x64, 0x21, 0x29, 0x21, 0x77
};

static unsigned char uff3b[] = { /* FF3B - FF40 */
  0x21, 0x4E, 0x21, 0x40, 0x21, 0x4F, 0x21, 0x30,
  0x21, 0x32, 0x21, 0x2E
};

static unsigned char uff5b[] = { /* FF5B - FF5D */
  0x21, 0x50, 0x21, 0x43, 0x21, 0x51
};

/* 
 * ʸ Unicode Character  EUC Ѵ d ؤΰ˥ȥ롣
 * ȥʸ֤
 */
static int ucs2toeuc(unsigned char *d, int uni)
{
  int hi, lo;
  unsigned char *tbl = NULL;

  lo = uni & 0xff;

  switch (uni & 0xff00) {
  case 0x0000:
    *d = lo;
    return (1);
  case 0x3000:
    uni = 2;  /* 0:cannot convert 1:1 byte character other:2 byte character */
    if (lo <= 0x15) {
      tbl = u3000;
    } else if (lo >= 0x41 && lo <= 0x93) {  /* hiragana */
      hi = 0x24;
      lo -= 0x20;
    } else if (lo >= 0x9b && lo <= 0x9e) {
      tbl = u309b;
      lo -= 0x9b;
    } else if (lo >= 0xa1 && lo <= 0xf6) { /* katakana */
      hi = 0x25;
    } else if (lo >= 0xfb && lo <= 0xfe) {
      tbl = u30fb;
      lo -= 0xfb;
    } else {
      uni = 0;
    }
    break;
  case 0xff00:
    uni = 2;
    if (lo <= 0x0f) {
      tbl = uff01;
      lo -= 0x01;
    } else if (lo <= 0x19) {  /* full width digit */
      hi = 0x23;
      lo += 0x21;
    } else if (lo <= 0x20) {
      tbl = uff1a;
      lo -= 0x1a;
    } else if ((lo <= 0x3a) || (lo >= 0x41 && lo <= 0x5a)) {
      hi = 0x23;
      lo += 0x20;
    } else if (lo <= 0x40) {
      tbl = uff3b;
      lo -= 0x3b;
    } else if (lo <= 0x5d) {
      tbl = uff5b;
      lo -= 0x5b;
    } else if (lo >= 0x61 && lo <= 0x9f) {
      hi = 0x8e;    /* half width katakana */
      lo += 0x40;
    } else {
      uni = 0;
    }
    break;
  default:
    uni = 0;
  }
  if (tbl != NULL) {
    lo <<= 1;
    hi = tbl[lo];
    lo = tbl[lo + 1];
  }
  if (uni == 0 || (hi == 0 && lo == 0)) {
    hi = '?';
    lo = '?';
  } else {
    hi |= 0x80;
    lo |= 0x80;
  }
  *d++ = (unsigned char)hi;
  *d = (unsigned char)lo;
  return (2);
}

/* ΤȤ Unicode  ISO-8859-X ȾѥʤޤޤƤȥ */
/*  */
void slrn_convert_utf82int(unsigned char *s)
{
  unsigned char *d = s;
  int ch, ch2;

  while(*s) {
    ch = *s++;
    if (ch & 0x80) {
      ch2 = *s++;
      if (ch2 == '\0') {
	break;
      }
      ch = (ch << 6) | (ch2 & 0x3f);
      if (ch & 0x0800) {
	ch2 = *s++;
	if (ch2 == '\0') {
	  break;
	}
	ch = (ch << 6) | (ch2 & 0x3f);
      } else {
	ch &= 0x07ff;
      }
      d += ucs2toeuc(d, ch);
    } else {
      *d++ = ch;
    }
  }
  *d = '\0';
  /* (void)jis2euc(s, s, strlen((char *)s)); */ /* ǰΤ */
}

void slrn_convert_utf72int(unsigned char *s)
{
  unsigned char *d = s;
  int ch, ch2, uni;
  int count = 0; /* current number of utf-7 encoded characters. */
                 /* This is set to 1 at each 8 characters */
                 /* zero means not encoded */

  while (*s) {
    ch = *s++;
    if (count == 0) {
      if (ch != '+') {
	*d++ = ch;
      } else if (*s == '-') { /* A sequence '+-' represents '+'. */
	*d++ = '+';
	s++;
      } else {
	count = 1;
	uni = 0;
      }
    } else {
      ch2 = slrn_base64(ch);
      if (ch2 != -1) {
	if (count == 4) {
	  uni = (((uni & 0x03) << 6) | ch2) << 8;
	} else if (count == 7) {
	  uni = (((uni & 0x0f) << 6) | ch2) << 6;
	} else {
	  uni |= (ch2 << ((52 - count * 6) % 16)) >> 4;
	}
      } else {
	if (ch != '-') {
	  *d++ = ch;
	}
	count = 0;
	continue;
      }
      if (count == 3 || count == 6 || count == 8) {
	/* convert to EUC */
	d += ucs2toeuc(d, uni);
	if (count == 8) {
	  uni = 0;
	  count = 0;
	} else { /* make next unicode */
	  uni = ch2;
	}
      }
      count++;
    }
  }
  *d = '\0';
}

#endif /* KANJI */
