/* Copyright (c) 1998 John E. Davis (davis@space.mit.edu)
 *
 * This file is part of slrn.
 *
 * Slrn is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * Slrn is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Slrn; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place - Suite 330, 
 * Boston, MA  02111-1307, USA.
 */

#include "config.h"
#include "slrnfeat.h"

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <time.h>

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif

#include <slang.h>
#include "jdmacros.h"

#ifdef KANJI
#include "khenkan.h"
#endif
#include "group.h"
#include "art.h"
#include "startup.h"
#include "misc.h"
#include "score.h"
#include "util.h"

int slrn_edit_score (Slrn_Header_Type *h, char *newsgroup)
{
   char ch = 'e';
   int ich;
   char file[256];
   char qregexp[512];
   unsigned int mm = 0, dd = 0, yy = 0;
   int use_expired = 0;
   unsigned int linenum = 0;
   char *q, *ng = newsgroup;
   int score;
   FILE *fp;
   time_t myclock;
   
   
   if (Slrn_Score_File == NULL)
     {
	slrn_error ("A Score file has not been specified.");
	return -1;
     }
   
   if (Slrn_Prefix_Arg_Ptr == NULL)
     {
#ifdef KANJI
	ch = slrn_get_response ("SsFfRrEeCc\007", Slrn_Japanese_Messages
				?  "μ: \001Subject, \001From, \001References, \001Edit, \001Cancel"
				: "Pick Score type: \001Subject, \001From, \001References, \001Edit, \001Cancel");
#else
	ch = slrn_get_response ("SsFfRrEeCc\007", "Pick Score type: \001Subject, \001From, \001References, \001Edit, \001Cancel");
#endif
	if (ch == 7) return -1;
	ch |= 0x20;
	if (ch == 'c') return -1;
   
	score = -9999;
	if (-1 == slrn_read_integer ("Score", &score, &score))
	  return -1;
	if (score == 0) return -1;
	
#ifdef KANJI
	if ('a' == (0x20 | slrn_get_response ("TtaA", Slrn_Japanese_Messages
					      ? "ɤΥ˥塼롼: \001This(Υ롼), \001All(٤ƤΥ롼)"
					      : "Which newsgroups: \001This group, \001All groups")))
#else
	if ('a' == (0x20 | slrn_get_response ("TtaA", "Which newsgroups: \001This group, \001All groups")))
#endif
	  ng = "*";

	while (1)
	  {
	     *qregexp = 0;
#ifdef KANJI
	     if (-1 == slrn_read_input (Slrn_Japanese_Messages
					? " (MM/DD/YYYY  DD-MM-YYYY ޤ϶Τޤ)"
					: "Expires (MM/DD/YYYY or DD-MM-YYYY or leave blank)", NULL, qregexp, 1, 0))
#else
	     if (-1 == slrn_read_input ("Expires (MM/DD/YYYY or DD-MM-YYYY or leave blank)", NULL, qregexp, 1, 0))
#endif
	       return -1;
	     if (*qregexp)
	       {
		  if (((3 != sscanf (qregexp, "%u/%u/%u", &mm, &dd, &yy))
		       && (3 != sscanf (qregexp, "%u-%u-%u", &dd, &mm, &yy)))
		      || (dd > 31)
		      || (mm > 12)
		      || (yy < 1900))
		    continue;
		  use_expired = 1;
		  break;
	       }
	     else
	       {
		  use_expired = 0;
		  break;
	       }
	  }
     }
   
   if ((NULL == (fp = slrn_open_home_file (Slrn_Score_File, "r+", file, 1)))
       && (NULL == (fp = slrn_open_home_file (Slrn_Score_File, "w+", file, 1))))
     {
	slrn_error ("Unable to open %s", file);
	return -1;
     }
   
   if (Slrn_Prefix_Arg_Ptr == NULL)
     {
	linenum = 1;
	while (EOF != (ich = getc (fp)))
	  {
	     if (ich == '\n')	linenum++;
	  }
	
	myclock = time((time_t *) 0);
	fprintf (fp, "\n%%Score created by slrn on %s\n[%s]\nScore: %d\n",
		 (char *) ctime(&myclock), ng, score);
	
	if (use_expired)
	  fprintf (fp, "Expires: %u/%u/%u\n", mm, dd, yy);
	else fprintf (fp, "%%Expires: \n");
	
	q = SLregexp_quote_string (h->subject, qregexp, sizeof (qregexp));
	if (q == NULL) q = h->subject;
	fprintf (fp, "%c\tSubject: %s\n",
		 ((ch == 's') ? ' ' : '%'), q);
	
	q = SLregexp_quote_string (h->from, qregexp, sizeof (qregexp));
	if (q == NULL) q = h->from;
	fprintf (fp, "%c\tFrom: %s\n",
		 ((ch == 'f') ? ' ' : '%'), q);
	
	q = SLregexp_quote_string (h->msgid, qregexp, sizeof (qregexp));
	if (q == NULL) q = h->msgid;
	fprintf (fp, "%c\tReferences: %s\n",
		 ((ch == 'r') ? ' ' : '%'), q);
	
	
	q = SLregexp_quote_string (h->xref, qregexp, sizeof(qregexp));
	if (q != NULL)
	  {
	     /* The way slrn handles Xref, we only need this: */
	     fprintf (fp, "%%\t%s\n", q);
	  }
	
	q = SLregexp_quote_string (newsgroup, qregexp, sizeof(qregexp));
	if (q == NULL) q = newsgroup;
	fprintf (fp, "%%\tNewsgroup: %s\n", q);
     }
   
   Slrn_Prefix_Arg_Ptr = NULL;

   if (-1 == slrn_fclose (fp))
     return -1;

#ifdef KANJI
   /* 񤭽Фե editor ɤѴ */
   if (Slrn_Editor_Code != EUC
       && slrn_conv_file(file, Slrn_Editor_Code) == -1) return (-1);
#endif
   if (ch == 'e')
     {
	int status;
	
	status = slrn_edit_file (Slrn_Editor_Score, file, linenum + 1, 1);

	if (status == -2)	       /* unmodified */
	  return 0;
	if (status < 0)
	  return -1;
     }
   slrn_message_now ("Reloading score file ...");
   (void) slrn_read_score_file (file);
#ifdef KANJI
   slrn_message (Slrn_Japanese_Messages
		 ? "롼פȴȡѹͭˤʤޤ"
		 : "Exit group for changes to take effect.");
#else
   slrn_message ("Exit group for changes to take effect.");
#endif
   return 0;
}
