#include <unistd.h>
#include <signal.h>
#include <string.h>

#include <X11/Xlib.h>
#include <gdk/gdkx.h>

#include "nptext.h"

void answer_buttons_callback( GtkWidget *widget, gpointer data )
{
   NP_Text *text = ( NP_Text *)data;

   if ( text->compose_pid || text->text == NULL )
   {
      text->show_message( "There is no message currently loaded." );
      return;
   }
   
   if ( text->header )
   {
      text->show_message( "News Peruser will not let you create a Follow-Up\n"
                          "or Reply to a header-only message." );
      return;
   }

   if ( !strcmp( text->server, "Folders" ))
   {
      text->show_message( "You cannot respond to articles in Folders." );
      return;
   }

   int what = ( int)gtk_object_get_data( GTK_OBJECT( widget ), "what" );

   char *type = NULL;

   switch( what )
   {
   case 0:
      type = "reply";
      break;

   case 1:
      type = "follow-up";
      break;

   case 2:
      type = "both";
      break;

   case 3:
      type = "cancel";
      break;

   case 4:
      type = "supersede";
      break;

   case 5:
      type = "edit";
      break;
   }

   if ( what == 3 || what == 4 )
   {
      if ( text->text != NULL &&
           ( strstr( text->text, "Control:" ) ||
             strstr( text->text, "Supersedes:" )))
      {
         text->show_message( "You cannot cancel or supersede a cancel or\n"
                             "supersede message." );
         return;
      }
   }

   switch( text->compose_pid = fork() )
      {
      case -1:
         perror( "fork" );
         return;
         break;

      case 0:
         close( ConnectionNumber( gdk_display ));

         char buffer[ 32 ];
         snprintf( buffer, sizeof buffer, "%d", text->offset );
         execlp( "npcompose", "npcompose", text->server, text->group,
                 type, buffer, NULL );
         perror( "execlp" );
         _exit( 1 );
         break;

      default:
         break;
      }

   return;
}
