#include <ctype.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <errno.h>

#include "npsummary.h"

char *NP_Summary::create_tree_entry( np_thread_node_t *pointer )
{
   static char buffer[ 1024 ];

   char total_buffer[ 128 ] = "";
   char headers_buffer[ 128 ] = "";
   char unseen_buffer[ 128 ] = "";

   if ( pointer->parent == NULL )
   {
      if ( pointer->descendents )
         snprintf( total_buffer, sizeof total_buffer, "%d : ",
               pointer->descendents );

      if ( pointer->unseen_descendents )
         snprintf( unseen_buffer, sizeof unseen_buffer, "%d/",
               pointer->unseen_descendents );

      if ( pointer->header_descendents )
         snprintf( headers_buffer, sizeof headers_buffer, "%d/%d : ",
               pointer->requested_descendents, pointer->header_descendents );
   }

   snprintf( buffer, sizeof buffer, "%s%s%s%s%s", 
             (( pointer->is_unseen < 0 ) ? "D " : "" ),
             unseen_buffer, total_buffer,
             headers_buffer, pointer->subject );

   return buffer;
}

void NP_Summary::create_subtree( GtkWidget *item, np_thread_node_t *pointer )
{
   pointer = pointer->child_head;
   GtkWidget *subtree = gtk_tree_new();
   gtk_widget_show( subtree );

   char *line;
   GtkWidget *child_item, *label;

   line = create_tree_entry( pointer );
   child_item = gtk_tree_item_new();
   gtk_widget_show( child_item );
   pointer->item = child_item;

   gtk_object_set_data( GTK_OBJECT( child_item ), "object", this );
   gtk_object_set_data( GTK_OBJECT( child_item ), "node", pointer );

   if ( pointer->is_article >= 0 )
   {
      items[ pointer->ordinal ] = child_item;

      gtk_signal_connect_object( GTK_OBJECT( child_item ), 
            "button_press_event",
            GTK_SIGNAL_FUNC( request_current_wrapper ), 
            GTK_OBJECT( child_item ));

      gtk_signal_connect_object( GTK_OBJECT( child_item ),
            "button_press_event",
            GTK_SIGNAL_FUNC( mark_shortcut_callback ),
            GTK_OBJECT( mark_menu ) );

      gtk_signal_connect_object( GTK_OBJECT( child_item ), 
            "button_press_event",
            GTK_SIGNAL_FUNC( request_shortcut_callback ),
            GTK_OBJECT( request_menu ) );
   }

   label = gtk_label_new( line );
   GtkStyle *style = NULL;
   if ( !pointer->is_article )
   {
      if ( pointer->is_requested )
         style = ( pointer->is_unseen ? unread_request_style : 
                                        request_style );
      else 
         style = ( pointer->is_unseen ? unread_header_style :
                                        header_style );
   }
   else if ( pointer->is_article < 0 )
      style = ( pointer->unseen_descendents ? unread_dummy_style : 
                                              dummy_style );
   else
      style = ( pointer->is_unseen ? unread_style : read_style );

   gtk_widget_set_style( label, style );

   gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
   gtk_container_add( GTK_CONTAINER( child_item ), label );

   pointer->label = label;

   gtk_widget_show( label );
   gtk_widget_show( child_item );
   gtk_tree_append( GTK_TREE( subtree ), child_item );
   gtk_tree_item_set_subtree( GTK_TREE_ITEM( item ), subtree );

   if ( pointer->child_count )
      create_subtree( child_item, pointer );

   while( pointer->child_next != NULL )
   {
      pointer = pointer->child_next;

      line = create_tree_entry( pointer );
      child_item = gtk_tree_item_new();
      gtk_widget_show( child_item );
      pointer->item = child_item;

      gtk_object_set_data( GTK_OBJECT( child_item ), "object", this );
      gtk_object_set_data( GTK_OBJECT( child_item ), "node", pointer );

      if ( pointer->is_article >= 0 )
      {
         items[ pointer->ordinal ] = child_item;

         gtk_signal_connect_object( GTK_OBJECT( child_item ), 
               "button_press_event",
               GTK_SIGNAL_FUNC( request_current_wrapper ),
               GTK_OBJECT( child_item ));

         gtk_signal_connect_object( GTK_OBJECT( child_item ), 
               "button_press_event",
               GTK_SIGNAL_FUNC( mark_shortcut_callback ),
               GTK_OBJECT( mark_menu ) );

         gtk_signal_connect_object( GTK_OBJECT( child_item ), 
               "button_press_event",
               GTK_SIGNAL_FUNC( request_shortcut_callback ),
               GTK_OBJECT( request_menu ) );
      }

      label = gtk_label_new( line );
      GtkStyle *style = NULL;
      if ( !pointer->is_article )
      {
         if ( pointer->is_requested )
            style = ( pointer->is_unseen ? unread_request_style : 
                  request_style );
         else 
            style = ( pointer->is_unseen ? unread_header_style :
                  header_style );
      }
      else if ( pointer->is_article < 0 )
         style = ( pointer->unseen_descendents ? unread_dummy_style : 
               dummy_style );
      else
         style = ( pointer->is_unseen ? unread_style : read_style );

      gtk_widget_set_style( label, style );

      gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
      gtk_container_add( GTK_CONTAINER( child_item ), label );

      pointer->label = label;

      gtk_widget_show( label );
      gtk_tree_append( GTK_TREE( subtree ), child_item );

      if ( pointer->child_count )
         create_subtree( child_item, pointer );
   }

   return;
}

int NP_Summary::update_tree()
{
   if ( tree_widget != NULL )
      gtk_widget_destroy( tree_widget );

   tree_widget = gtk_tree_new();
   gtk_widget_show( tree_widget );

   gtk_tree_set_selection_mode( GTK_TREE( tree_widget ), 
         GTK_SELECTION_SINGLE );
   gtk_signal_connect( GTK_OBJECT( tree_widget ), "selection_changed",
            GTK_SIGNAL_FUNC( tree_widget_callback ), this );
   gtk_container_border_width( GTK_CONTAINER( tree_widget ), 10 );
   gtk_scrolled_window_add_with_viewport( GTK_SCROLLED_WINDOW( scroll ),
         tree_widget );

   int failed = 0;
   if (( tree = threads.get_tree( server, group, hide_seen, hide_headers, 1 ))
       == NULL )
      failed = 1;
   else
      if (( spool_beginning = threads.get_spool_beginning()) == NULL )
         failed = 1;

   threads.get_totals( &total, &headers, &unseen, &requested );

   if ( items != NULL )
      free( items );

   items = ( GtkWidget **)calloc( total, sizeof *items );
   if ( items == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s", group );

   int l = strlen( buffer );
   char *temp_pointer = buffer;
   for( int i = 0; i < l; ++i )
   {
      *temp_pointer = toupper( *temp_pointer );
      ++temp_pointer;
   }

   if ( group_label != NULL )
      gtk_widget_destroy( group_label );

   group_label = gtk_label_new( buffer );
   gtk_widget_show( group_label );
   gtk_table_attach_defaults( GTK_TABLE( table ), group_label, 0, 39, 0, 1 );

   if ( failed )
   {
      if ( list_onscreen )
         gtk_clist_clear( GTK_CLIST( list ));

      return 1;
   }

   np_thread_node_t *pointer;

   for( pointer = tree; pointer != NULL; pointer = pointer->next )
   {
      if ( pointer->is_child )
         continue;

      char *line = create_tree_entry( pointer );
      GtkWidget *item = gtk_tree_item_new();
      gtk_widget_show( item );

      gtk_object_set_data( GTK_OBJECT( item ), "object", this );
      gtk_object_set_data( GTK_OBJECT( item ), "node", pointer );

      if ( pointer->is_article >= 0 )
      {
         items[ pointer->ordinal ] = item;

         gtk_signal_connect_object( GTK_OBJECT( item ), 
               "button_press_event",
               GTK_SIGNAL_FUNC( request_current_wrapper ), 
               GTK_OBJECT( item ));

         gtk_signal_connect_object( GTK_OBJECT( item ), 
               "button_press_event",
               GTK_SIGNAL_FUNC( mark_shortcut_callback ),
               GTK_OBJECT( mark_menu ) );

         gtk_signal_connect_object( GTK_OBJECT( item ), 
               "button_press_event",
               GTK_SIGNAL_FUNC( request_shortcut_callback ),
               GTK_OBJECT( request_menu ) );
      }

      GtkWidget *label = gtk_label_new( line );
      GtkStyle *style = NULL;
      if ( !pointer->is_article )
      {
         if ( pointer->is_requested )
            style = ( pointer->is_unseen ? unread_request_style : 
                  request_style );
         else
            style = ( pointer->is_unseen ? unread_header_style :
                  header_style );
      }
      else if ( pointer->is_article < 0 )
         style = ( pointer->unseen_descendents ? unread_dummy_style : 
               dummy_style );
      else
         style = ( pointer->is_unseen ? unread_style : read_style );

      gtk_widget_set_style( label, style );

      gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
      gtk_container_add( GTK_CONTAINER( item ), label );

      pointer->item = item;
      pointer->label = label;

      gtk_widget_show( label );
      gtk_tree_append( GTK_TREE( tree_widget ), item );

      if ( pointer->child_count )
         create_subtree( item, pointer );
   }

   if ( list_onscreen )
      sort_list_callback( NULL, this );

   return 0;
}
