#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npthreads.h"

void NP_Threads:: recursively_fill_gaps( np_thread_node_t *parent,
                                         np_thread_node_t *child,
                                         int gap )
{
   np_thread_node_t *temp;
   if (( temp = ( np_thread_node_t *)malloc( sizeof *temp )) == NULL )
   {
      perror( "malloc" );
      exit( 1 );
   }

   temp->ordinal = -1;
   temp->next = parent;
   temp->prev = parent->prev;
   temp->spool_prev = temp->spool_next = ( np_thread_node_t *)1;

   if ( parent->prev != NULL )
      parent->prev->next = temp;
   else
      threads = temp;

   parent->prev = temp;

   temp->parent = parent;

   if ( parent->child_head == child )
      parent->child_head = temp;

   if ( parent->child_tail == child )
      parent->child_tail = temp;

   temp->child_prev = child->child_prev;
   temp->child_next = child->child_next;

   if ( child->child_prev != NULL )
      child->child_prev->child_next = temp;

   if ( child->child_next != NULL )
      child->child_next->child_prev = temp;
   
   temp->child_head = child;
   temp->child_tail = child;

   child->parent = temp;
   child->child_next = NULL;
   child->child_prev = NULL;

   if (( temp->subject = strdup( "(missing precursor)" )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   temp->date = temp->message_id = temp->from = NULL;
   temp->gap = --gap;
   temp->offset = temp->size = -1;
   temp->references = NULL;
   temp->is_article = temp->is_unseen = temp->is_requested = -1;
   temp->is_child = 1;
   temp->child_count = 1;
   temp->descendents = temp->unseen_descendents =
      temp->requested_descendents = temp->header_descendents = 0;

   if ( gap )
      recursively_fill_gaps( temp, child, gap );

   if ( temp->child_next != NULL )
   {
      np_thread_node_t *pointer;
      for( pointer = temp->child_next;
           pointer != NULL;
           pointer = pointer->child_next )
         if ( pointer->gap )
            recursively_fill_gaps( parent, pointer, pointer->gap );
   }

   return;
}

np_thread_node_t *NP_Threads::make_phony_root( NP_Stringarray& nodes )
{
   int total_nodes = nodes.get_total();
   if ( total_nodes < 0 )
   {
      snprintf( error_message, sizeof error_message, "NP_Threads: "
                "make_phony_root(): %s", nodes.get_error());
      return NULL;
   }

   if ( total_nodes < 2 )
      return NULL;

   np_thread_node_t *node;
   if (( node = ( np_thread_node_t *)malloc( sizeof *node )) == NULL )
   {
      perror( "malloc" );
      exit( 1 );
   }

   node->ordinal = -1;
   node->parent = NULL;
   node->date = node->message_id = node->from = NULL;
   node->gap = 0;
   node->offset = node->size = -1;
   node->references = NULL;
   node->is_article = node->is_unseen = node->is_requested = -1;
   node->is_child = 0;
   node->child_count = total_nodes;
   node->descendents = node->unseen_descendents = node->requested_descendents =
      node->header_descendents = 0;
   
   char *pointer = ( char *)nodes[ 0 ];
   if ( pointer == NULL )
   {
      snprintf( error_message, sizeof error_message, "NP_Threads: "
                "make_phony_root(): %s", nodes.get_error());
      return NULL;
   }

   np_thread_node_t *current = ( np_thread_node_t *)atoi( pointer );
   if ( !current )
      return NULL;

   if (( node->subject = strdup( current->subject )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   node->prev = current->prev;

   if ( current->prev != NULL )
      current->prev->next = node;
   else
      threads = node;

   current->prev = node;

   node->next = current;
   node->child_head = current;
   node->child_next = NULL;
   node->child_prev = NULL;
   node->spool_prev = node->spool_next = ( np_thread_node_t *)1;

   current->parent = node;
   current->child_prev = NULL;
   current->is_child = 1;

   np_thread_node_t *temp;

   for( int i = 1; i < total_nodes; ++i )
   {
      temp = current;

      pointer = ( char *)nodes[ i ];
      if ( pointer == NULL )
      {
         snprintf( error_message, sizeof error_message, "NP_Threads: "
                   "make_phony_root(): %s", nodes.get_error());
         return NULL;
      }
      current = ( np_thread_node_t *)atoi( pointer );
      current->is_child = 1;
      current->parent = node;
      temp->child_next = current;
      current->child_prev = temp;
   }

   node->child_tail = current;
   current->child_next = NULL;

   return node;
}

void NP_Threads::recursively_count_descendents( int *count, int *unseen,
                                                int *requested,
                                                int *headers,
                                                np_thread_node_t *pointer )
{
   if ( pointer->is_unseen != -1 )
   {
      ++( *count );

      if ( pointer->is_unseen )
         ++( *unseen );

      if ( !pointer->is_article )
         ++( *headers );

      if ( pointer->is_requested )
         ++( *requested );
   }
   
   if ( pointer->child_next != NULL )
      recursively_count_descendents( count, unseen, requested, headers,
                                     pointer->child_next );

   if ( pointer->child_count )
      recursively_count_descendents( count, unseen, requested, headers,
                                     pointer->child_head );

   return;
}

int NP_Threads::fill_gaps()
{
   if ( total < 2 )
      return 0;

   NP_Stringarray node_array;
   np_thread_node_t *pointer;

   for( pointer = threads; pointer != NULL; pointer = pointer->next )
   {
       if ( pointer->child_count )
          for( np_thread_node_t *inner_pointer = pointer->child_head;
                inner_pointer != NULL;
                inner_pointer = inner_pointer->child_next )
          {
             if ( inner_pointer->gap )
                recursively_fill_gaps( pointer, inner_pointer,
                                       inner_pointer->gap );
          }
   }

   char *prev_subject = "";
   np_thread_node_t *prev_pointer = NULL;
   int success = 0;

   for( pointer = threads; pointer!= NULL; pointer = pointer->next )
   {
      if ( pointer->is_child )
         continue;

      if ( !strcmp( prev_subject, pointer->subject ))
      {
         char buffer[ 128 ];
         if ( !success )
         {
            snprintf( buffer, sizeof buffer, "%u", prev_pointer );
            if ( node_array.add_item( buffer ))
            {
               snprintf( error_message, sizeof error_message, "NP_Threads: "
                         "fill_gaps(): %s", node_array.get_error());
               return 1;
            }
         }

         success = 1;
         snprintf( buffer, sizeof buffer, "%u", pointer );
         if ( node_array.add_item( buffer ))
         {
            snprintf( error_message, sizeof error_message, "NP_Threads: "
                      "fill_gaps(): %s", node_array.get_error());
            return 1;
         }
      }
      else
         if ( success )
         {
            np_thread_node_t *temp = make_phony_root( node_array );
            if ( temp != NULL )
               pointer = temp;

            success = 0;
            if ( node_array.clear() )
            {
               snprintf( error_message, sizeof error_message, "NP_Threads: "
                         "fill_gaps(): %s", node_array.get_error());
               return 1;
            }
         }

      prev_subject = pointer->subject;
      prev_pointer = pointer;
   }

   if ( success )
   {
      np_thread_node_t *temp = make_phony_root( node_array );
      if ( temp != NULL )
         pointer = temp;

      success = 0;
      if ( node_array.clear() )
      {
         snprintf( error_message, sizeof error_message, "NP_Threads: "
                   "fill_gaps(): %s", node_array.get_error());
         return 1;
      }
   }

   for( pointer = threads; pointer != NULL; pointer = pointer->next )
      if ( !pointer->is_child && pointer->child_count )
         recursively_count_descendents( &pointer->descendents,
                                        &pointer->unseen_descendents,
                                        &pointer->requested_descendents,
                                        &pointer->header_descendents,
                                        pointer->child_head );

   return 0;
}

