#include <signal.h>

#include "npsummary.h"

void NP_Summary::kill_my_children()
{
   int total = children.get_total();
   if ( total < 0 )
   {
      children.print_error();
      return;
   }

   if ( total )
   {
      signal( SIGCHLD, SIG_IGN );

      for( int i = 0; i < total; ++i )
      {
         char *p = ( char *)children[ i ];
         if ( p == NULL )
         {
            children.print_error();
            continue;
         }

         pid_t pid = ( pid_t)atoi( p );
         if ( pid )
            kill( pid, SIGTERM );
      }

      if ( children.clear())
         children.print_error();

      SIGCHLD_handler( 0 );
      signal( SIGCHLD, SIGCHLD_handler );
   }
   
   return;
}
