#include <signal.h>
#include <string.h>
#include <unistd.h>

#include "npsummary.h"

void input_callback( gpointer data, gint fd, GdkInputCondition condition )
{
   NP_Summary *summary = ( NP_Summary *)data;

   char server[ 1024 ], group[ 1024 ], article[ 16 ], line[ 16 ];

   if ( summary->reading )
      return;
   
   summary->reading = 1;

   int ordinal = -1;
   if ( summary->current_node != NULL )
      ordinal = summary->current_node->ordinal;

   char old_server[ 1024 ], old_group[ 1024 ];
   strcpy( old_server, summary->server );
   strcpy( old_group, summary->group );

   if ( summary->input == NULL )
      if (( summary->input = fdopen( STDIN_FILENO, "r" )) == NULL )
      {
         perror( "fdopen" );
         return;
      }

   if ( fgets( server, sizeof server, summary->input ) == NULL )
   {
      fclose( summary->input );
      summary->input = NULL;
      return;
   }

   if ( fgets( group, sizeof group, summary->input ) == NULL )
   {
      fclose( summary->input );
      summary->input = NULL;
      return;
   }

   if ( fgets( article, sizeof article, summary->input ) == NULL )
   {
      fclose( summary->input );
      summary->input = NULL;
      return;
   }
   
   if ( fgets( line, sizeof line, summary->input ) == NULL )
   {
      fclose( summary->input );
      summary->input = NULL;
      return;
   }

   int position = atoi( article );
   if ( position > -2 )
      summary->write_read_file();
   
   strtok( server, "\n" );
   strtok( group, "\n" );
   strtok( article, "\n" );

   if ( !( summary->text_line = atoi( line )))
      if ( summary->text_pid )
         kill( summary->text_pid, SIGUSR1 );
   
   if ( summary->server != NULL )
      free( summary->server );

   if ( summary->group != NULL )
      free( summary->group );

   if (( summary->server = strdup( server )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   if (( summary->group = strdup( group )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   if ( summary->tree == NULL || strcmp( summary->server, old_server ) ||
         strcmp( old_group, summary->group ))
      summary->update_tree();

   if ( --position >= 0 )
      for( np_thread_node_t *pointer = summary->tree;
           pointer != NULL;
           pointer = pointer->next )
      {
         if ( pointer->ordinal == position )
         {
            np_thread_node_t *old = pointer;

            while( pointer->is_child == 1 )
            {
               pointer = pointer->parent;
               gtk_tree_item_expand( GTK_TREE_ITEM( pointer->item ));
            }

            summary->button = 1;
            if ( summary->selected_item == old->item )
               tree_widget_callback( summary->tree_widget, data );
            else
               gtk_tree_select_child( GTK_TREE( summary->tree_widget ),
                     GTK_WIDGET( old->item ));
            summary->button = 0;
            break;
         }
      }
   else
   {
      summary->selected_item = NULL;
      summary->current_node = NULL;
   }

   if ( !strcmp( group, "FOLLOW-UPS" ) ||
         !strcmp( group, "POSTED" ) ||
         !strcmp( group, "OUTBOX" ) ||
         !strcmp( group, "SENT-MAIL" ))
   {
      gtk_widget_show( summary->remove_button );
      gtk_widget_hide( summary->mark_button );
      gtk_widget_hide( summary->hide_button );
      gtk_widget_hide( summary->request_button );
      gtk_widget_hide( summary->compose_button );
   }
   else
   {
      if ( !strcmp( server, "Folders" ))
      {
         gtk_widget_hide( summary->compose_button );
         gtk_widget_show( summary->remove_button );
      }
      else
      {
         gtk_widget_show( summary->compose_button );
         gtk_widget_hide( summary->remove_button );
      }

      gtk_widget_show( summary->request_button );
      gtk_widget_show( summary->mark_button );
      gtk_widget_show( summary->hide_button );
   }

   summary->reading = 0;

   return;
}
