#include <stdlib.h>
#include <stdio.h>
#include <regex.h>
#include <string.h>

#include "npfile.h"
#include "npstringarray.h"
#include "nppex.h"

int NP_Pex::convert_date( char *date, char **converted )
{
   static int compiled = 0;
   static regex_t regex;
   regmatch_t *matches;
   int result;

   if ( date == NULL )
   {
      if ( compiled )
         regfree( &regex );

      compiled = 0;
      return 0;
   }

   char buffer[ 1024 ], *wdy, *dd, *mon, *yyyy, *hh, *mm, *ss, *tzn;
   
   if ( !compiled )
   {
      // Will match slightly wonky headers as well as the kosher. 

      wdy    = "([A-Z][a-z][a-z], +)?";
      dd     = "([0-3]?[0-9]) +";
      mon    = "([A-Z]?[a-z]+) +";
      yyyy   = "([0-9][0-9])?([0-9][0-9]) +";
      hh     = "([0-2]?[0-9])";
      mm     = ":?([0-5]?[0-9])";
      ss     = "(:([0-5]?[0-9]))?";
      tzn    = "( +[A-Z][A-Z][A-Z]| +[+-][0-2][0-9][0-5][0-9])?";

      strcpy( buffer, wdy );
      strcat( buffer, dd );
      strcat( buffer, mon );
      strcat( buffer, yyyy );
      strcat( buffer, hh );
      strcat( buffer, mm );
      strcat( buffer, ss );
      strcat( buffer, tzn );

      if ( ( result = regcomp( &regex, buffer, REG_EXTENDED )))
      {
         strcpy( error_message, "NP_Pex: convert_date(): " );
         regerror( result, &regex, buffer, sizeof buffer );
         strcat( error_message, buffer );
         return 1;
      }

      compiled = 1;
   }

   if (( matches =
         ( regmatch_t *)calloc( regex.re_nsub + 1, sizeof *matches )) == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   if (( result = regexec( &regex, date, regex.re_nsub + 1, matches, 0 )))
   {
      strcpy( error_message, "NP_Pex: convert_date(): " );
      regerror( result, &regex, buffer, sizeof buffer );
      strcat( error_message, buffer );
         
      if ( result == REG_NOMATCH )
      {
         if (( *converted = strdup( "" )) 
               == NULL )
         {
            perror( "strdup" );
            exit( 1 );
         }

         snprintf( error_message, sizeof error_message,
                   "NP_Pex: convert_date(): unrecognized date header: %s",
                   date );
         return 2;
      }
      
      return 1;
   }

   /* discard Wdy */

   strncpy( buffer, date + matches[ 2 ].rm_so, 
            ( result = matches[ 2 ].rm_eo - matches[ 2 ].rm_so ));
   buffer[ result ] = '\0';
   int day = atoi( buffer );

   /* month */

   strncpy( buffer, date + matches[ 3 ].rm_so,
         ( result = matches[ 3 ].rm_eo - matches[ 3 ].rm_so ));
   buffer[ result ] = '\0';
   int month = convert_month( buffer );

   /* year */

   result = 0;
   buffer[ 0 ] = '\0';
   if ( matches[ 4 ].rm_so > 0 )
   {
      strncpy( buffer, date + matches[ 4 ].rm_so,
               ( result = matches[ 4 ].rm_eo - matches[ 4 ].rm_so ));
      buffer[ result ] = '\0';
   }

   strncat( buffer, date + matches[ 5 ].rm_so,
            ( result += matches[ 5 ].rm_eo - matches[ 5 ].rm_so ));
   buffer[ result ] = '\0';

   int year;
   if ( ( year = atoi( buffer )) < 100 )
      if ( buffer[ 0 ] == '9' )
         year += 1900;
      else
         year += 2000;

   /* hours */

   strncpy( buffer, date + matches[ 6 ].rm_so,
            ( result = matches[ 6 ].rm_eo - matches[ 6 ].rm_so ));
   buffer[ result ] = '\0';
   int hours = atoi( buffer );

   /* minutes */

   strncpy( buffer, date + matches[ 7 ].rm_so,
            ( result = matches[ 7 ].rm_eo - matches[ 7 ].rm_so ));
   buffer[ result ] = '\0';
   int minutes = atoi( buffer );

   /* seconds */

   strncpy( buffer, date + matches[ 9 ].rm_so,
            ( result = matches[ 9 ].rm_eo - matches[ 9 ].rm_so ));
   buffer[ result ] = '\0';
   int seconds = atoi( buffer );

   /* timezone */

   if ( matches[ 10 ].rm_so > 0 )
   {
      strncpy( buffer, date + matches[ 10 ].rm_so + 1,
               ( result = matches[ 10 ].rm_eo - matches[ 10 ].rm_so - 1 ));
      buffer[ result ] = '\0';
   }
   else
      strcpy( buffer, "GMT" );

   free( matches );

   /* convert to GMT */

   convert_zone( buffer );

   char second_buffer[ 1024 ];
   if ( strncmp( buffer, "unknown", 7 ))
   {
      strcpy( second_buffer, buffer );

      strncpy( buffer, second_buffer, 3 );
      buffer[ 3 ] = '\0';

      hours += atoi( buffer );

      strncpy( buffer, second_buffer + 3 , 3 );
      buffer[ 3 ] = '\0';

      minutes += atoi( buffer );

      /* convert to locale time */

      convert_localtime( &hours, &minutes, &seconds, &day, &month, &year );

      snprintf( buffer, sizeof buffer, "%4d%02d%02d%02d%02d%02d", 
                year, month, day, hours, minutes, seconds );
   }
   else
      strcpy( buffer, " (unknown timezone)" );

   if (( *converted = strdup( buffer )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   return 0;
}
