#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "nplauncher.h"

NP_Launcher *np_launcher_p = NULL;

void SIGCHLD_handler( int signo )
{
   while( waitpid( -1, NULL, WNOHANG ) > 0 );

   return;
}

void SIGUSR1_handler( int signo )
{
   gdk_window_raise( np_launcher_p->window->window );
   signal( SIGUSR1, SIGUSR1_handler );
   return;
}

NP_Launcher::~NP_Launcher()
{
   if ( total )
   {
      for( int i = 0; i < total; ++i )
         if ( tasks[ i ] != NULL )
            free( tasks[ i ] );

      free( tasks );
   }

   while( waitpid( -1, NULL, WNOHANG ) > 0 );

   return;
}

NP_Launcher::NP_Launcher( int *argc, char ***argv )
{
   np_launcher_p = this;

   gtk_init( argc, argv );

   signal( SIGCHLD, SIGCHLD_handler );
   signal( SIGUSR1, SIGUSR1_handler );

   window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
   gtk_widget_realize( window );
   gtk_signal_connect( GTK_OBJECT( window ), "delete_event",
                       GTK_SIGNAL_FUNC( close_button_callback ), window );
   gtk_signal_connect( GTK_OBJECT( window ), "destroy",
                       GTK_SIGNAL_FUNC( close_button_callback ), window );

   GtkWidget *toolbar = gtk_toolbar_new( GTK_ORIENTATION_VERTICAL, 
                                         GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_container_add( GTK_CONTAINER( window ), toolbar );
   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Close ",
                            "Close the toolbar window.", NULL, NULL,
                            GTK_SIGNAL_FUNC( close_button_callback ),
                            window );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   total = 0;
   tasks = NULL;

   NP_File file;
   char *message = NULL;

   if ( file.openr( "/usr/share/news-peruser/peruser4-helpers" ))
      if ( errno != ENOENT )
         message = strerror( errno );
      else if ( file.openr( "/usr/local/share/news-peruser/peruser4-helpers" ))
         if ( errno != ENOENT )
            message = strerror( errno );
         else
            message = "No helper apps have been configured.";

   if ( message != NULL )
   {
      show_message( message );

      while( message_window != NULL )
         while( gtk_events_pending() )
            gtk_main_iteration();

      return;
   }

   char *line;
   for( ; ; )
   {
      if (( line = file.get_string()) == NULL )
         break;

      if ( *line == '\n' )
         continue;

      ++total;
   }

   if ( file.seek( 0, SEEK_SET ))
   {
      file.print_error();
      return;
   }

   if (( tasks = ( char **)calloc( total, sizeof *tasks )) == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   for( int i = 0; i < total; ++i )
   {
      line = file.get_string();
      if ( line == NULL )
         break;

      if ( *line == '\n' )
      {
         gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));
         --i;
         continue;
      }

      char *title = strtok( line, ":" );
      char *tip = strtok( NULL, ":" );
      tasks[ i ] = strtok( NULL, "\n" );

      if (( tasks[ i ] = strdup( tasks[ i ] )) == NULL )
      {
         perror( "strdup" );
         exit( 1 );
      }

      gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), title, tip, 
                               NULL, NULL,
                               GTK_SIGNAL_FUNC( buttons_callback ), 
                               tasks[ i ] );
   }

   file.close();

   gtk_widget_show( window );

   return;
}
