#include <signal.h>
#include <unistd.h>

#include "npconfig.h"

void save_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Config *config = ( NP_Config *)data;

   if ( config->general.save() )
      config->general.print_error();

   if ( config->subscription.save() )
      config->subscription.print_error();

   if ( config->folders_f.save() )
      config->folders_f.print_error();

   int total = config->deleted.get_total();
   if ( total < 0 )
      config->deleted.print_error();
   else
      if ( total )
         for( int i = 0; i < total; ++i )
         {
            char *filename = ( char *)config->deleted[ i ];
            if ( filename == NULL )
            {
               config->deleted.print_error();
               continue;
            }
            
            config->remove_files( filename );
         }
   
   if ( config->deleted.clear())
   {
      config->deleted.print_error();
      return;
   }
   
   config->dirty = 0;

   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.npcollections:pid", config->home );
   FILE *file;
   if (( file = fopen( buffer, "r" )) != NULL )
   {
      char *result = fgets( buffer, sizeof buffer, file );
      fclose( file );

      if ( result == NULL )
         return;
      
      pid_t pid = atoi( buffer );
      if ( pid )
         kill( pid, SIGUSR1 );
   }
   
   return;
}
