#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npsubscription.h"

int NP_Subscription::get_total_groups( int i )
{
   if ( i < 0 || i >= total )
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "get_total_groups(): server index %d out of range.", i );
      return -1;
   }

   int result = group_list[ i ].group_names->get_total();
   if ( result < 0 )
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "get_total_groups(): %s",
                group_list[ i ].group_names->get_error() );
      return -1;
   }
   
   return result;
}
