#include "npconfig.h"

void NP_Config::load_clist( GtkWidget *clist )
{
   char buffer[ 1024 ];
   const char *server = subscription[ current_server ];
   if ( server == NULL )
   {
      subscription.print_error();
      return;
   }
   
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-LIST", home,
             server );
   int result;
   if (( result = list_file.openr( buffer )))
   {
      if ( result != 2 )
         list_file.print_error();

      return;
   }

   active_groups = 0;

   gtk_clist_clear( GTK_CLIST( clist ));
   gtk_clist_freeze( GTK_CLIST( clist ));

   char *group[ 2 ], *line;
   while(( line = list_file.get_string() ) != NULL )
   {
      group[ 0 ] = strtok( line, ":" );
      group[ 1 ] = strtok( NULL, "\n" );

      gtk_clist_append( GTK_CLIST( clist ), group );

      ++active_groups;
   }

   list_file.close();

   snprintf( buffer, sizeof buffer, "%d Active Newsgroups", active_groups );
   gtk_clist_set_column_title( GTK_CLIST( clist ), 0, buffer );
   gtk_clist_thaw( GTK_CLIST( clist ));

   return;
}
