#include "npconfig.h"

void NP_Config::init_servers( GtkWidget *frame )
{
   if ( subscription.load() )
      subscription.print_error();

   // table
   
   GtkWidget *table = gtk_table_new( 10, 1, FALSE );
   gtk_widget_show( table );
   gtk_container_add( GTK_CONTAINER( frame ), table );
   gtk_container_border_width( GTK_CONTAINER( table ), 10 );
   
   // scroll
   
   GtkWidget *scroll = gtk_scrolled_window_new( NULL, NULL );
   gtk_widget_show( scroll );
   gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scroll ),
                                   GTK_POLICY_AUTOMATIC,
                                   GTK_POLICY_AUTOMATIC );
   gtk_table_attach_defaults( GTK_TABLE( table ), scroll, 1, 10, 0, 1 );

   // outer box

   GtkWidget *outer_box = gtk_vbox_new( FALSE, 10 );
   gtk_widget_show( outer_box );
   gtk_object_set_data( GTK_OBJECT( outer_box ), "config", this );
   gtk_container_border_width( GTK_CONTAINER( outer_box ), 5 );
   gtk_scrolled_window_add_with_viewport( GTK_SCROLLED_WINDOW( scroll ), 
                                          outer_box );

   // toolbar
   
   GtkWidget *toolbar = gtk_toolbar_new( GTK_ORIENTATION_VERTICAL,
                                         GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Add ", "Add a news"
                            " server to the list of servers you wish to"
                            " access with News Peruser.", NULL, NULL,
                            GTK_SIGNAL_FUNC( add_button_callback ),
                            outer_box );
   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Remove ",
                            "Remove one of the news servers from the list.",
                            NULL, NULL,
                            GTK_SIGNAL_FUNC( remove_button_callback ),
                            outer_box );
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 0, 1, 0, 1 );

   create_server_list( outer_box );
   
   return;
}
