#include <gtk/gtk.h>

#include "npconfig.h"

void do_dialog( int type, void *data )
{
   GtkWidget *outer_box = ( GtkWidget *)data;
   
   NP_Config *config =
      ( NP_Config *)gtk_object_get_data( GTK_OBJECT( outer_box ), "config" );

   // window
   
   GtkWidget *window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
   gtk_container_border_width( GTK_CONTAINER( window ), 10 );

   gtk_window_set_title( GTK_WINDOW( window ),
                         ( type ? "Add News Server" : "Remove News Server" ));

   // vbox

   GtkWidget *vbox = gtk_vbox_new( FALSE, 0 );
   gtk_widget_show( vbox );
   gtk_container_add( GTK_CONTAINER( window ), vbox );
   
   // label
   
   GtkWidget *label = gtk_label_new( "Enter Server Name:" );
   gtk_widget_show( label );
   gtk_box_pack_start( GTK_BOX( vbox ), label, TRUE, TRUE, 5 );
   
   // entry
   
   GtkWidget *entry = gtk_entry_new_with_max_length( 100 );
   gtk_widget_show( entry );
   gtk_object_set_data( GTK_OBJECT( entry ), "config", config );
   gtk_object_set_data( GTK_OBJECT( entry ), "window", window );
   gtk_object_set_data( GTK_OBJECT( entry ), "box", outer_box );
   gtk_box_pack_start( GTK_BOX( vbox ), entry, TRUE, TRUE, 10 );

   // separator

   GtkWidget *separator = gtk_hseparator_new();
   gtk_widget_show( separator );
   gtk_box_pack_start( GTK_BOX( vbox ), separator, TRUE, TRUE, 10 );

   // hbox 

   GtkWidget *bbox = gtk_hbutton_box_new();
   gtk_widget_show( bbox );
   gtk_box_pack_start( GTK_BOX( vbox ), bbox, TRUE, TRUE, 0 );

   void *callback = ( type ? dialog_add_callback : dialog_remove_callback );
   
   // buttons
   
   GtkWidget *button = gtk_button_new_with_label( "OK" );
   gtk_widget_show( button );
   GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
   gtk_box_pack_start( GTK_BOX( bbox ), button, TRUE, TRUE, 0 );
   gtk_widget_grab_default( button );
   gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                       GTK_SIGNAL_FUNC( callback ), entry );
   gtk_object_set_data( GTK_OBJECT( button ), "button", ( gpointer )1 );

   button = gtk_button_new_with_label( "Cancel" );
   gtk_widget_show( button );
   GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
   gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                       GTK_SIGNAL_FUNC( callback ), entry );
   gtk_object_set_data( GTK_OBJECT( button ), "button", ( gpointer )0 );
   gtk_box_pack_start( GTK_BOX( bbox ), button, TRUE, TRUE, 0 );

   gtk_grab_add( window );
   gtk_widget_show( window );

   return;
}
