#include "npconfig.h"

void NP_Config::create_folder_frame( GtkWidget *frame, NP_Folders *folders,
                                     char *label1, char *label2 )
{
   GtkWidget *table = gtk_table_new( 10, 10, FALSE );
   gtk_widget_show( table );
   gtk_container_add( GTK_CONTAINER( frame ), table );
   gtk_container_border_width( GTK_CONTAINER( table ), 10 );
   GtkWidget *vbox = gtk_vbox_new( FALSE, 0 );
   gtk_widget_show( vbox );
   gtk_table_attach_defaults( GTK_TABLE( table ), vbox, 0, 10, 0, 1 );

   char buffer[ 256 ];
   snprintf( buffer, sizeof buffer, "%s:", label1 );
   GtkWidget *label = gtk_label_new( buffer );
   gtk_widget_show( label );
   gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 5 );

   GtkWidget *name_entry = gtk_entry_new_with_max_length( 100 );
   gtk_widget_show( name_entry );
   gtk_box_pack_start( GTK_BOX( vbox ), name_entry, FALSE, FALSE, 5 );

   GtkWidget *filter_entry = NULL;
   if ( label2 != NULL )
   {
      snprintf( buffer, sizeof buffer, "%s:", label2 );
      label = gtk_label_new( buffer );
      gtk_widget_show( label );
      gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 5 );
   
      filter_entry = gtk_entry_new_with_max_length( 100 );
      gtk_widget_show( filter_entry );
      gtk_box_pack_start( GTK_BOX( vbox ), filter_entry, FALSE, FALSE, 5 );
   }

   GtkWidget *toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                                         GTK_TOOLBAR_TEXT );
   gtk_object_set_data( GTK_OBJECT( toolbar ), "name_entry", name_entry );
   gtk_widget_show( toolbar );

   char *text = (( label2 == NULL ) ? "entry" : "entries" );
   snprintf( buffer, sizeof buffer, "Add the contents of the %s to the list, "
             "creating a new entry", text );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Add ", buffer,
                            NULL, NULL,
                            GTK_SIGNAL_FUNC( new_folder_callback ), this );

   snprintf( buffer, sizeof buffer, "Replace the selected item's line in "
             "the list with the contents of the %s, modifying the item's "
             "description", text );
   
   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Replace ", buffer,
                            NULL, NULL,
                            GTK_SIGNAL_FUNC( replace_folder_callback ), this );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Remove ",
                            "Remove the selected item from the list", NULL,
                            NULL, GTK_SIGNAL_FUNC( remove_folder_callback ),
                            this );
   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Sort ",
                            "Sort the list.", NULL,
                            NULL, GTK_SIGNAL_FUNC( sort_folders_callback ),
                            this );
   gtk_box_pack_start( GTK_BOX( vbox ), toolbar, FALSE, FALSE, 10 );

   static char *titles[ 2 ];
   titles[ 0 ] = label1;
   titles[ 1 ] = label2;

   GtkWidget *list_scroll = gtk_scrolled_window_new( NULL, NULL );
   gtk_widget_show( list_scroll );
   gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( list_scroll ),
                                    GTK_POLICY_AUTOMATIC,
                                    GTK_POLICY_AUTOMATIC );

   GtkWidget *clist = gtk_clist_new_with_titles(
      (( label2 == NULL ) ? 1 : 2 ), titles );
   gtk_widget_show( clist );
   gtk_object_set_data( GTK_OBJECT( clist ), "name_entry", name_entry );
   gtk_clist_set_column_width( GTK_CLIST( clist ), 0, 300 );
   gtk_clist_set_column_width( GTK_CLIST( clist ), 1, 300 );
   gtk_signal_connect( GTK_OBJECT( clist ), "select_row",
                       GTK_SIGNAL_FUNC( folder_clist_callback ), this );
   gtk_signal_connect( GTK_OBJECT( clist ), "unselect_row",
                       GTK_SIGNAL_FUNC( folder_clist_callback ), this );

   gtk_container_add( GTK_CONTAINER( list_scroll ), clist );
   gtk_table_attach_defaults( GTK_TABLE( table ), list_scroll, 0, 10, 1, 10 );

   if ( label2 != NULL )
      gtk_object_set_data( GTK_OBJECT( table ), "filter_entry", filter_entry );
   gtk_object_set_data( GTK_OBJECT( toolbar ), "clist", clist );
   gtk_object_set_data( GTK_OBJECT( toolbar ), "object", folders );
   
   int total = folders->get_total();

   if ( !total )
      return;

   if ( total < 0 )
   {
      folders->print_error();
      return;
   }

   gtk_clist_freeze( GTK_CLIST( clist ));
   
   for( int i = 0; i < total; ++i )
   {
      char *lines[ 2 ];
      if ( folders->get_items( i, &lines[ 0 ], &lines[ 1 ] ))
      {
         folders->print_error();
         return;
      }

      gtk_clist_append( GTK_CLIST( clist ), lines );
   }

   gtk_clist_thaw( GTK_CLIST( clist ));
   
   return;
}
