#include <stdlib.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void down_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   if ( !collections->total_groups )
      return;

   if ( collections->selected_item == NULL )
      return;

   NP_Collections::np_master_group_list_t *group = 
      collections->master_group_list;

   for( int i = 0; i < collections->total_groups; ++i )
   {
      if ( collections->selected_item == group[ i ].node )
      {
         while( --i >= 0 )
            if ( group[ i ].unseen )
            {
               collections->button = 1;
               gtk_tree_select_child( GTK_TREE( collections->tree_widget ),
                                      group[ i ].node );
               collections->button = 0;
               break;
            }

         break;
      }
   }


   return;
}


