#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npstringarray.h"

int NP_Stringarray::replace_item( int i, const char *replacement )
{
   if ( mutex )
      return 3;

   mutex = 1;

   if ( i < 0 || i >= total )
   {
      snprintf( error_message, sizeof error_message,
               "NP_Stringarray: replace_item(): index out of range: %d.", i );
      mutex = 0;
      return 2;
   }

   if ( replacement == NULL )
   {
      strcpy( error_message, "NP_Stringarray: replace_item(): NULL "
              "replacement item passed as argument." );
      mutex = 0;
      return 1;
   }

   if ( item_list[ i ] != NULL )
   {
      if ( !duplicates_allowed )
      {
         int j;
         char **pointer = item_list;
         for( j = 0; j < total; ++j )
         {
            if ( i == j )
            {
               ++pointer;
               continue;
            }

            if ( !strcmp( *pointer++, replacement ))
               break;
         }
         
         if ( j != total )
         {
            snprintf( error_message, sizeof error_message,
                      "NP_Stringarray: replace_item(): replacing %s with %s"
                      " would create a duplicate entry.", item_list[ i ],
                      replacement );
            mutex = 0;
            return 2;
         }
      }
      
      free( item_list[ i ] );
      if (( item_list[ i ] = strdup( replacement )) == NULL )
      {
         perror( "strdup" );
         exit( 1 );
      }
   }
   else
   {
      snprintf( error_message, sizeof error_message,
                "NP_Stringarray: replace_item(): item %d is NULL. "
                "This should never happen!", i );
      mutex = 0;
      return 1;
   }

   mutex = 0;
   return 0;
}

int NP_Stringarray::replace_item( const char *old, const char *replacement )
{
   if ( mutex )
      return 3;

   mutex = 1;
   
   if ( old == NULL )
   {
      strcpy( error_message, "NP_Stringarray: replace_item(): NULL old item"
              " name passed as argument." );
      mutex = 0;
      return 1;
   }

   if ( replacement == NULL )
   {
      strcpy( error_message, "NP_Stringarray: replace_item() NULL "
              "replacement item passed as argument." );
      mutex = 0;
      return 1;
   }

   char **pointer = item_list;
   int i;

   for( i = 0; i < total; ++i )
   {
      if ( *pointer == NULL )
      {
         strcpy( error_message, "NP_Stringarray: replace_item(): "
                 "there is a NULL item in this object."
                 "This should never happen!" );
         mutex = 0;
         return 1;
      }

      if ( !strcmp( old, *pointer ))
         break;

      ++pointer;
   }
   
   if ( i == total )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Stringarray: replace_item(): "
                "no such item has been added to this object: %s.",
                replacement );
      mutex = 0;
      return 1;
   }

   if ( !duplicates_allowed )
   {
      int j;
      char **pointer = item_list;
      for( j = 0; j < total; ++j )
      {
         if ( i == j )
         { 
            ++pointer;
            continue;
         }

         if ( !strcmp( *pointer++, replacement ))
            break;
      }
      
      if ( j != total )
      {
         snprintf( error_message, sizeof error_message,
                   "NP_Stringarray: replace_item(): replacing %s with %s"
                   " would create a duplicate entry.", item_list[ i ],
                   replacement );
         mutex = 0;
         return 2;
      }
   }

   free( *pointer );
   if (( *pointer = strdup( replacement )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   mutex = 0;
   return 0;
}

