#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include "npfile.h"

int NP_File::put_string( char *s )
{
   if ( !is_open )
   {
      snprintf( error_message, sizeof error_message,
                "NP_File: putstring(): No file is open for this object" );
      return 1;
   }

   int result;
   if (( result = fputs( s, stream )) < 0 || result == EOF )
   {
      snprintf( error_message, sizeof error_message, "NP_File: putstring(): "
                "fputs() returned error: %s", strerror( errno ));
      return 1;
   }

   return 0;
}
