/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PAN_OBJECT_H
#define PAN_OBJECT_H

#define PAN_OBJECT(a) ((PanObject*)a)

typedef struct _PanObject PanObject;
typedef void (*PanObjectDestructor)(PanObject*);


struct _PanObject
{
	/* virtual functions */
	PanObjectDestructor destructor;

	/* fields */
	int ref_count;
	gpointer user_data;
};

/* protected */
extern void pan_object_constructor (PanObject*, PanObjectDestructor);
extern void pan_object_destructor (PanObject*);

/* public */
extern PanObject* pan_object_new (void);
extern void pan_object_sink (PanObject*);
extern void pan_object_destroy (PanObject*);
extern void pan_object_ref (PanObject*);
extern void pan_object_unref (PanObject*);

extern gpointer pan_object_get_user_data (const PanObject*);
extern void pan_object_set_user_data (PanObject*, gpointer);

#endif
