/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __MESSAGE_H__
#define __MESSAGE_H__

#include <glib.h>
#include <gtk/gtkwidget.h>

#include "server.h"
#include "group.h"
#include "article.h"

typedef struct _Message Message;
typedef struct _MessageWindow MessageWindow;

typedef enum {
	NNTP_ARTICLE_READ,
	NNTP_ARTICLE_POST,
	NNTP_ARTICLE_REPLY,
//	EMAIL_READ,
	EMAIL_POST,
	EMAIL_REPLY,
	EMAIL_FORWARD
} MessageWindowType;

struct _Message
{
	MessageWindowType type;
	MessageWindow *window;
	gboolean needs_window;

	GSList *rcpts;

	gchar *to;
	gchar *from;
        gchar *newsgroups;
	gchar *organization;
	gchar *date;
	gchar *subject;
	gchar *body;
	gchar *references;

        gchar *reply_to;
        gchar *followup_to;

	gchar *message_id;
	gchar *full_text;

	const server_data *sdata;
	group_data *gdata;
};


/*
==============================

  Function Prototypes

==============================
*/

Message* message_copy (const Message *src);
void	 message_free (Message *msg);
Message* message_new (const server_data*, group_data *, const article_data *article);

void message_previous (GtkWidget *widget, Message *msg);
void message_next (GtkWidget *widget, Message *msg);

void message_import_adata (Message *msg, const article_data *adata);

#endif
