/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __ARTICLE_H__
#define __ARTICLE_H__

#include <time.h>
#include <glib.h>
#include "group.h"
#include "pan-callback.h"

#define ARTICLE_DATA(a) ((article_data *)a)

enum {
	STATE_NONE		= 0,
	STATE_MULTIPART_ALL	= 1<<0,
	STATE_MULTIPART_SOME	= 1<<1,
	STATE_DOWNLOAD_QUEUED	= 1<<2,
	STATE_DECODE_QUEUED	= 1<<3,
	STATE_READ		= 1<<4,
	STATE_DECODED		= 1<<5,
	STATE_ERROR		= 1<<6,
	STATE_NEW		= 1<<7,
	STATE_CACHED		= 1<<8,
	STATE_DECODE_FAILED	= 1<<9,
	STATE_KILLFILE		= 1<<10, /* only used in articlelist */
	STATE_WATCHED		= 1<<11, /* only used in articlelist */
	STATE_UNREAD_CHILDREN   = 1<<12  /* only used in articlelist */
};

typedef struct _article_data
{
/* basic info */
	gchar *number;
	gchar *subject;
	gchar *author;
	gchar *message_id;
	gchar *references; /* ??? */
	time_t date;
	gint linecount;

/* optional info */
	gchar *reply_to;
	gchar *followup_to;
	gchar *newsgroups;

/* multipart info */
	gint parts; /* no. of parts to whole multipart message */
	gint part;  /* current part no. */

/* articlelist */
	struct _article_data* parent; /* parent in threaded view */
	GSList *threads; /* linked list of threads */
	gint unread_children;
	gboolean self_passes_filter;
	gboolean tree_passes_filter;

/* group */
	gulong state;
}
article_data;



extern PanCallback* article_deleted_callback;

extern void article_init (void);

/**
 * This reparents all of adata's children to be children of adata's parent,
 * removes adata from its parent's child list, and
 * clears out all of adata's parent/child references.
 */
extern void article_isolate (article_data*);

extern article_data* article_new (void);

extern void article_free_gfunc (
	gpointer, /* article_data* */
	gpointer ); /* unused user-data */

extern void article_free (
	article_data*);

extern article_data* article_copy (
	article_data* target,
	const article_data* source);

extern gchar* article_get_thread_message_id (
	const article_data*);

/**
***
**/

#if 0
extern gboolean article_flag_on (
	const article_data* adata,
	int flag);
#else
#define article_flag_on(a, flag) (a && (a->state&flag))
#endif

extern void article_mark_read (
	const server_data*,
	const group_data*,
	article_data*,
	gboolean sync);

extern void articles_mark_read (
	const server_data*,
	const group_data*,
	article_data**,
	int article_qty,
	gboolean sync);

extern void article_mark_unread (
	const server_data*,
	const group_data*,
	article_data*,
	gboolean sync);

extern void articles_mark_unread (
	const server_data*,
	const group_data*,
	article_data**,
	int article_qty,
	gboolean sync);

extern void article_delete (
	const server_data*,
	const group_data*,
	article_data*,
	gboolean sync);

extern void articles_delete (
	const server_data*,
	const group_data*,
	article_data**,
	int article_qty,
	gboolean sync);

/**
***
**/

extern void article_add_flag (
	const server_data*,
	const group_data*,
	article_data*,
	int,
	gboolean sync);

extern void article_remove_flag (
	const server_data*,
	const group_data*,
	article_data*,
	int,
	gboolean sync);

extern void article_update (
	const server_data*,
	const group_data*,
	const article_data*,
	gboolean sync);

/**
***
**/

/**
 * @param adata the article whose thread is to be returned
 * @return a bag of all the articles threaded into this article.
 *         adata's parent/children fields are traversed for this.
 */
extern void article_get_entire_thread (
	article_data* adata,
	int *setme_qty,
	article_data ***setme_buf);

#endif /* __ARTICLE_H__ */
