/*  VER 163   TAB P   $Id: request.c,v 1.10 1999/03/11 07:30:01 src Exp $
 *
 *  keep track of outstanding NNTP requests
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: request.c,v $
 *  Revision 1.10  1999/03/11 07:30:01  src
 *  Implemented check for spool free space
 *
 *  Revision 1.9  1999/03/09 11:43:57  src
 *  Cosmetic fixes
 *
 *  Revision 1.8  1998/11/21 19:14:24  src
 *  Added --filter option
 *
 *  Revision 1.7  1998/09/09 07:32:13  src
 *  Version 1.1
 *
 *  Revision 1.6  1998/07/12 09:39:30  src
 *  newsx version 1.0
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "nntp.h"

/*
 *  outstanding request descriptor
 */
struct req {
    int (*req_fn)(char *, long, char *);
    long req_where;
    char *req_group;
} ;

static struct req req_queue[REQ_MAX];
static int req_n = 0;
static int req_head = 0;
static int req_tail = 0;

/* 
 *  get status line from NNTP
 *  return false if trouble
 */
static int 
get_status(void)
{
    char status[NNTP_STRLEN+1];
    struct req *rp;

    if (req_n == 0) return 1; /* nothing to do */
    --req_n;
    rp = &(req_queue[req_tail]);
    if (++req_tail >= REQ_MAX) req_tail = 0;

    /* get status */
    if (!get_server_nntp_nf(status, sizeof(status))) {
	/* timeout */
	return 0;
    }

    return (*rp->req_fn)(status, rp->req_where, rp->req_group);
}

/* 
 *  send a request
 *  return false if trouble
 */
int 
put_request(char *request, int (*fn)(), long where,char *group)
{
    struct req *rp;
    int req_max = REQ_MAX;

    if (window) req_max = window > REQ_MAX ? req_max : window;
    else req_max = 1;

    while (req_n >= req_max) {
	/* request queue is full, must read */
	if (!get_status()) return 0;
    }

    rp = &(req_queue[req_head]);
    rp->req_fn    = fn;
    rp->req_where = where;
    rp->req_group = group;

    ++req_n;
    if (++req_head >= REQ_MAX) req_head = 0;

    if (!put_server(request)) return 0;

    if (window == 0) return flush_request(); /* don't leave requests */

    return 1;
}

/* 
 *  process one request from queue
 *  return false if trouble, negative if empty queue
 */
int 
process_request(void)
{
    if (req_n <= 0) return -1;
    return get_status();
}

/* 
 *  flush request queue
 *  return false if trouble
 */
int 
flush_request(void)
{
    while (req_n > 0) {
	/* request queue is full, must read */
	if (!get_status()) return 0;
    }
    return 1;
}
