/*********************************************
**********************************************

This file contains code relating to the messageing
queue.  Where messages are stored.

The plan to implement this goes like this:

If queuing is enabled (USE_QUEUE == TRUE)

- When a message is recived:
  - Log it(!)
  - Add it to queue.
  - Write queue to file. (~/.zicq/queue.dat)
  - Notify user of new messages

- To read a message:
  - Find first message (FIRST_PTR)
	- OR -
  - Find message based on UIN
  - Display message.
  - Remove from Queue
  - Rewrite Queue file
	- OR, if no messages left -
  - Remove Queue file

- When the program loads
  - Check for a Queue file
  - Read Queue into memory and alert user
	- Or, if no queue file - 
  - Skip this

*********************************************
**********************************************/

struct queue_message {
	time_t recieved;
	DWORD uin;
	int type;
	char* data;
	char* desc;
	queue_message *NEXT;
	queue_message *PREV;
} QMSG, *QPTR;

void add_queue(DWORD uin, int type, char* data, char* desc) {
	}
