#if defined( _USE_GTK )

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "wmppxp-util.h"

/* Common data */
char buf_label[16];
GtkWidget *label;
GtkWidget *box_frame;             /* Top level wrapping widget */
GtkWidget *box_notebook;          /* Wrapping widget for notebook */
GtkWidget *box_button;            /* Wrapping widget for button */
GtkWidget *text_log;              /* Text widget for showing log */

GdkFont *fixed_font;

/* File */
FILE *log_file;
FILE *conf_file;

/* path to the files */
char *path_to_conf_file = NULL;
char *path_to_log_file = NULL;

/* Current file stream position */
int current_pos;
int text_line_num;
int text_height = 0;
int max_string_width = 0;

#define SPACE " "
#define MIN_TEXT_WIDTH_LINES     20
#define MIN_TEXT_HEIGHT_LINES    10
#define TEXT_BORDER_ROOM         1

void CloseUtil( GtkWidget *widget, GtkWidget* event, gpointer data )
{
  if( path_to_conf_file )
  {
    free( path_to_conf_file );
  }
  if( path_to_log_file )
  {
    free( path_to_log_file );
  }

  gtk_exit( 0 );
}

int WMPPxPUtilMain( int argc, char *argv[] )
{
  GtkWidget *window;                /* Top level window */
  GtkWidget *notebook;              /* Console, log and setting */
  GtkWidget *table;                 /* Table widget */
  GtkWidget *hseparator;            /* Horizontal separator */

  /* Search paths to conf file and log file directory */
  path_to_conf_file = (char*)malloc( sizeof( char ) * 256 );
  path_to_log_file = (char*)malloc( sizeof( char ) * 256 );
  SearchPath();

  /* Initialize gtk */
  gtk_init( &argc, &argv );

  /* Create top level window */
  window = gtk_window_new( GTK_WINDOW_TOPLEVEL );

  /* Set window default size */
  gtk_widget_set_usize( window, 600, 400 );

  /* Register exit function */
  gtk_signal_connect( GTK_OBJECT( window ), "delete_event",
                      GTK_SIGNAL_FUNC( CloseUtil ), NULL );

  /* Set window title */
  gtk_window_set_title( GTK_WINDOW( window ), "WMPPxP Utility Window" );
  
  gtk_container_set_border_width( GTK_CONTAINER( window ), 0 );

  /*
    Create top level wrapping widget which will contain
    2 wrapping widget and a horizotal separator
  */
  box_frame = gtk_vbox_new( FALSE, 0 );
  gtk_container_add( GTK_CONTAINER( window ), box_frame );
  gtk_widget_show( box_frame );

  /*
    Create next level wrapping widget which will contain
    notebook widget
  */
  box_notebook = gtk_vbox_new( FALSE, 10 );
  gtk_container_set_border_width( GTK_CONTAINER( box_notebook ), 10 );
  gtk_box_pack_start( GTK_BOX( box_frame ), box_notebook, TRUE, TRUE, 0 );
  gtk_widget_show( box_notebook );

  /*
    Create table widget which will contain notebook widget
  */
  table = gtk_table_new( 1, 1, FALSE );
  gtk_box_pack_start( GTK_BOX( box_notebook ), table, TRUE, TRUE, 0 );
  gtk_widget_show( table );

  /*
    Create notebook widget which has console text widget, log text widget
    and setting component widget
  */
  notebook = gtk_notebook_new();
  gtk_notebook_set_tab_pos( GTK_NOTEBOOK( notebook ), GTK_POS_TOP );
  gtk_table_attach_defaults( GTK_TABLE( table ), notebook, 0, 1, 0, 1 );
  gtk_widget_show( notebook );

  CreateSettingTab( notebook );
  CreateLogTab( notebook );
  /*  CreateConsoleTab( notebook ); */


  /* Set the log text widget as a default page of the notebook */
  gtk_notebook_set_page( GTK_NOTEBOOK( notebook ), 0 );

  /* Create horizontal separator */
  hseparator = gtk_hseparator_new();
  gtk_box_pack_start( GTK_BOX( box_frame ), hseparator, FALSE, TRUE, 0 );
  gtk_widget_show( hseparator );

  CreateCloseButton();

  gtk_widget_show( window );

  gtk_main();

  return 0;
}

void CreateConsoleTab( GtkWidget *notebook )
{
  GtkWidget *table_for_console;
  GtkWidget *text_console;

  /*
    Create table which is attached to notebook widget to
    align console text widget
  */
  table_for_console = gtk_table_new( 3, 4, FALSE );
  sprintf( buf_label, "PPxP Console" );
  label = gtk_label_new( buf_label );
  gtk_notebook_prepend_page( GTK_NOTEBOOK( notebook ), table_for_console, label );
  gtk_widget_show( table_for_console );

  /*
    Create console text widget and put some spacing to align a log text widget
    in the middle of the notebook widget
  */
  text_console = gtk_text_new( NULL, NULL );
  gtk_text_set_editable( GTK_TEXT( text_console ), FALSE );
  gtk_table_set_row_spacing( GTK_TABLE( table_for_console ), 0, 10 );
  gtk_table_set_row_spacing( GTK_TABLE( table_for_console ), 1, 10 );
  gtk_table_set_col_spacing( GTK_TABLE( table_for_console ), 0, 10 );
  gtk_table_set_col_spacing( GTK_TABLE( table_for_console ), 2, 10 );
  gtk_table_attach( GTK_TABLE( table_for_console ), text_console, 1, 2, 1, 2,
                    GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                    GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0 );
  gtk_widget_show( text_console );
}

void CreateLogTab( GtkWidget *notebook )
{
  GtkWidget *table_for_log;
  GtkWidget *vscrollbar;
  GtkWidget *hscrollbar;

  GtkWidget *scroll_window;

  int width, height;
  int length;
  GtkRequisition requisition;

  scroll_window = gtk_scrolled_window_new( NULL, NULL );
  gtk_container_set_border_width( GTK_CONTAINER( scroll_window ), 10 );
  gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scroll_window ),
                                  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS );

  sprintf( buf_label, "PPxP Log View" );
  label = gtk_label_new( buf_label );
  gtk_notebook_prepend_page( GTK_NOTEBOOK( notebook ), scroll_window, label );
  gtk_widget_show( scroll_window );

  text_log = gtk_text_new( NULL, NULL );
  gtk_text_set_editable( GTK_TEXT( text_log ), FALSE );
  gtk_scrolled_window_add_with_viewport( GTK_SCROLLED_WINDOW( scroll_window ),
                                         text_log );
  gtk_widget_show( text_log );

  ShowLog();

}

void CreateSettingTab( GtkWidget* notebook )
{
  GtkWidget* frame;
  GtkWidget* box_setting;

  /*
    Create wrapping widget which is attached to notebook widget
  */
  sprintf( buf_label, "PPxP Settings" );
  label = gtk_label_new( buf_label );
  box_setting =  gtk_vbox_new( FALSE, 10 );
  gtk_notebook_prepend_page( GTK_NOTEBOOK( notebook ), box_setting, label );
  gtk_widget_show( box_setting );

  frame = gtk_frame_new( NULL );
  gtk_container_set_border_width( GTK_CONTAINER( frame ), 10 );
  gtk_box_pack_start( GTK_BOX( box_setting ), frame, TRUE, TRUE, 0 );
  gtk_widget_show( frame );
}

void CreateCloseButton()
{
  GtkWidget *button;

  /*
    Create wrapping widget which will hold button widget and is put under
    a notebook widget
  */
  box_button = gtk_vbox_new( FALSE, 10 );
  gtk_container_set_border_width( GTK_CONTAINER( box_button ), 10 );
  gtk_box_pack_start( GTK_BOX( box_frame ), box_button, FALSE, TRUE, 0 );
  gtk_widget_show( box_button );

  /*
    Create a button widget which makes this window exit
  */
  button = gtk_button_new_with_label( "close" );
  gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                      GTK_SIGNAL_FUNC( CloseUtil ), NULL );
  gtk_box_pack_start( GTK_BOX( box_button ), button, TRUE, TRUE, 0 );
  GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
  gtk_widget_grab_default( button );
  gtk_widget_show( button );
}

void SearchPath()
{
  char *home_dir;
  char buf[1024];
  char *str;
  int i, ret;

  home_dir = getenv( "HOME" );
  if( isp_name == NULL )
  {
    path_to_conf_file = NULL;
    strcpy( path_to_log_file, home_dir );
    strcat( path_to_log_file, "/.ppxp/log/qdial.log" );
  }
  else
  {
    /* To get conf file location */
    strcpy( path_to_conf_file, home_dir );
    strcat( path_to_conf_file, "/.ppxp/conf/" );
    strcat( path_to_conf_file, isp_name );

    conf_file = fopen( path_to_conf_file, "r" );
    if( conf_file )
    {
      i = 1;
      while( ( ret = ReadLine( conf_file, buf, 1024, i ) ) != -1 )
      {
        i++;
        /*printf( "Char num: %d, %s\n", ret, buf );*/
        /* buf contains the string "LOG.FILE" */
        str = strstr( buf, "LOG.FILE" );
        if( str )
	{
          /* str must be log file name after this */
          str = strpbrk( str, SPACE );
          /* In case str has space at the head of str, remove it. */
          while( *str == ' ' )
	  {
            str = ++str;
	  }

          /* Finally, wmppxp gets path to the log file */
          strcpy( path_to_log_file, home_dir );
          strcat( path_to_log_file, "/.ppxp/log/" );
          strcat( path_to_log_file, str );
	}
      }

      fclose( conf_file );
    }
  }
}

int ReadLine( FILE *file, char *buf, int buf_size, int line )
{
  int c;
  int count = 0;
  
  for( count=0; count<buf_size; count++ )
  {
    buf[count] = fgetc( file );
    if( buf[count] == '\n' || buf[count] == '\r' )
    {
      buf[count] = '\0';
      break;
    }
    else if( buf[count] == EOF )
    {
      return -1;
    }
  }
  
  return count;
}

void ShowLog()
{
  /* Ready to insert some text */
  /*gtk_widget_realize( text_log );*/
  /* Freeze the text widget, ready for multiple updates */
  gtk_text_freeze( GTK_TEXT( text_log ) );

  /* Load a fixed font */
  /*fixed_font = gdk_font_load( "-misc-fixed-medium-r-*-*-*-120-*-*-*-*-*-*" );*/
  fixed_font = gdk_font_load( "-*-fixed-medium-r-*-*-14-*-*-*-*-*-iso8859-1" );

  log_file = fopen( path_to_log_file, "r" );
  if( log_file )
  {
    char buf[1024];
    int nchars;

    while( ( nchars = ReadLine( log_file, buf, 1024, text_line_num ) ) != -1 )
    {
      buf[nchars] = '\n';
      gtk_text_insert( GTK_TEXT( text_log ), fixed_font, NULL, NULL,
                       buf, nchars + 1 );
      text_line_num++;
      text_height += ( gdk_string_height( fixed_font, buf ) +
                       fixed_font->descent );
      max_string_width = max( max_string_width, gdk_string_width( fixed_font, buf ) );
    }
  }

  fclose( log_file );

  gtk_text_thaw( GTK_TEXT( text_log ) );

  /* re-set text widget size to adjust h and v scrollbar */
  gtk_widget_set_usize( text_log, max_string_width + 10, text_height + 10 );
}

void UpdateLog()
{
}

#endif  /* End of _USE_GTK */
