// cfgft1.cpp
//
// mods:
// 19990715/tm	debian changes - check for lockfile before starting
//		note, the pathname is hardcoded!
//////////////////////////////////////////////////////////////////
#include "gtypes.h"
#include "sanguart.hpp"
#include <string.h>
#include <iostream.h>
#include <stdio.h>

#ifdef DEBIAN
#include <sys/stat.h>
#include <unistd.h>
#endif

#ifdef PLAT_LINUX
  int  kbdhit(int *);
#endif


void usage()
{
    cout << "usage: cfgft1 [-pHexPortNumber] [-mHexMemAddr] [-cChannel(0==A, 1==B)]\r\n" << flush ;
}

int main(int l_argc, char *l_argv[])
{
    BOOL             l_b_init_stat;

    int   l_i_in_char;
    char  l_c_in_char;
    char  l_c_out_char;

    int   l_i_port = 0x360;
    int   l_i_mem = 0xd0000;
    int   l_i_channel = 1;

    char *  stmp;
    int     argc = l_argc;
    char ** argv = l_argv;
    
#ifdef DEBIAN
    struct stat statbuf;
    char lockpath[80] = "/var/lock/wanpipe\0";
#endif

    cout << "S508 Async Virtual Terminal Version 1.01\r\n" << flush;

#ifdef DEBIAN
    if (stat(lockpath, &statbuf) == 0) {
       cout << "The lockfile " << lockpath << " exists!" << endl;
       cout << "cfgft1 cannot be run safely while wanpipe is running" << endl;
       cout << "Please stop wanpipe before using cfgft1" << endl << flush;
       exit(1);
    }
#endif

    for (argc--, argv++; argc > 0; argc--, argv++)
    {
        stmp = NULL;

        switch (argv[0][1])
        {
          case 'P':
          case 'p':                // Sangoma port
            {
              if (argv[0][2])
               {
                  stmp = &(argv[0][2]);
               }
              else
               {
                  argc--;
                  argv++;
                  stmp = argv[0];
               }

              if (!stmp || (sscanf(stmp, "%x", &l_i_port) != 1) )
               {
                  cout <<  ": Invalid port" << endl ;
                  usage();
                  break;
               }
              break;
            }

          case 'M':
          case 'm':                // Console Command and Control port
            {
              if (argv[0][2])
               {
                  stmp = &(argv[0][2]);
               }
              else
               {
                  argc--;
                  argv++;
                  stmp = argv[0];
               }

              if (!stmp || (sscanf(stmp, "%x", &l_i_mem) != 1) )
               {
                  cout <<  ": Invalid memory addr" << endl ;
                  usage();
                  return -1;
               }
              break;
          }

          case 'C':
          case 'c':                // Sangoma channel
            {
              if (argv[0][2])
               {
                  stmp = &(argv[0][2]);
               }
              else
               {
                  argc--;
                  argv++;
                  stmp = argv[0];
               }


              if (!stmp || (sscanf(stmp, "%x", &l_i_channel) != 1) )
               {
                  cout <<  ": Invalid channel addr" << endl ;
                  usage();
                  return -1;
               }
              break;
            }


          case 'H':
          case 'h':                // Sangoma Help
            {
                usage();
                return -1;
            }
            break;

          default:
            {
              cout << ": Unknown switch: -" << argv[0][1]<< endl;
              usage();
              return -1;
              break;
            }

         } // end switch
      } //end  for args


    cout << "Initializing Sangoma at port " << hex << l_i_port << " memory " << l_i_mem;
    cout << " channel " << dec ;
    char l_cp_chan = l_i_channel == 0 ? 'A' : 'B';
    cout << l_cp_chan << "\r\n" << flush;

    cSangVirtUart   *l_comm = new cSangVirtUart(l_i_port, l_i_mem,
                                                l_i_channel);
    l_b_init_stat = l_comm->InitUart();

    if (l_b_init_stat == FALSE)
    {
        cout << "Sangoma Init Fail." << flush;
        return -1;
    }

    cout << "Sangoma Initialized.  Hit escape to end.\r\n" << flush;
    while (1)
    {
        if (kbdhit(&l_i_in_char) == 0)
        {
            if(l_comm->getChar(&l_c_out_char) == TRUE)
            {
                cout << l_c_out_char << flush;
            }
        }
        else
        {
            l_c_in_char = l_i_in_char;
            if (l_c_in_char == 0x1b)
            {
                    break;
            }
            l_comm->putChar(&l_c_in_char);
        }
    }

    return 1;
}
