#
#
#
#

proc Toplevel:Start {window class title main_flag procedure arg_list} {
    if [winfo exists $window] {
	if {[wm state $window] != "normal"} {
	    wm deiconify $window
	}
	raise $window
	return 0
    } else {
	if $main_flag {
	    frame $window -class $class
	    . configure -borderwidth 0
	    wm title . $title
	    pack $window -padx 0 -pady 0 -fill both -expand yes
	} else {
	    toplevel $window -class $class
	    wm title $window $title
	}
	eval $procedure $window $arg_list

	return 1
    }
}

proc Toplevel:Close {window} {
    global PPxP

    set toplevel [winfo toplevel $window]
    if {$toplevel == "."} {
	$PPxP bye
    }
    destroy $toplevel
}

proc Toplevel:Quit {window} {
    global PPxP

    set toplevel [winfo toplevel $window]
    if {$toplevel == "."} {
	$PPxP quit
    }
    destroy $toplevel
}
