#
#
#
#

proc shift {arrayname} {
    upvar $arrayname array

    set first [lindex $array 0]
    set array [lrange $array 1 end]

    return $first
}

set util_trace_id 0

proc set_trace {varname op cmd} {
    global util_trace_id util_trace_varname util_trace_operation
    upvar \#0 $varname var

    set id $util_trace_id

    proc util:trace_handler_$id {name elem op} [list uplevel \#0 $cmd]
    trace variable var $op util:trace_handler_$id

    set util_trace_varname($id) $varname
    set util_trace_operation($id) $op

    incr util_trace_id
    return $id
}

proc del_trace {id} {
    global util_trace_varname util_trace_operation

    set varname $util_trace_varname($id)
    set operation $util_trace_operation($id)

    if {$varname != "" && $operation != ""} {
	set util_trace_varname($id) {}
	set util_trace_operation($id) {}

	upvar \#0 $varname var
	trace vdelete var $operation util:trace_handler_$id
	rename util:trace_handler_$id {}
    }
}
