#
#
#
#

switch -glob [exec uname -s] {
    Linux {
	set qdial_device_list \
	    [glob -nocomplain /dev/modem /dev/ttyS* /dev/cua*]
    }
    FreeBSD {
	set qdial_device_list \
	    [glob -nocomplain /dev/ttyd* /dev/cuaa*]
    }
    * {
	set qdial_device_list [lsort [glob -nocomplain /dev/*]]
    }
}

if {![info exists env(LANG)]} {
    set env(LANG) "C"
}

if {[info commands kanji] == "kanji" && [regexp {^ja} $env(LANG)]} {
    set qdial_help_wrap char
    option readfile [file join $RESOURCEDIR qdial_message.ja]
} else {
    set qdial_help_wrap word
    option readfile [file join $RESOURCEDIR qdial_message]
}

proc qdial:title_frame {frame} {
    set f [frame $frame]
    label $f.title

    pack $f.title -side left
}

proc qdial:help_window {frame} {
    global qdial_help_wrap

    frame $frame

    text $frame.helpText -width 42 -height 10 \
	-relief sunken -state disabled -wrap $qdial_help_wrap \
	-yscrollcommand "$frame.yscroll set"
    scrollbar $frame.yscroll -orient vertical \
	-command "$frame.helpText yview"

    pack $frame.helpText -side left -fill both -expand yes
    pack $frame.yscroll -side left -fill y

    global qdial_help_window
    set qdial_help_window $frame.helpText
}

proc qdial:show_help {help} {
    global qdial_help_window

    set w $qdial_help_window
    $w configure -state normal
    $w delete 0.0 end
    $w insert end $help
    $w configure -state disabled
}

proc qdial:get_help {win} {
    set text [option get $win helpText {}]
    regsub -all {\\n} $text "\n" text
    return $text
}

proc qdial:normal_entry {entry item} {
    entry $entry -textvariable PPxPVar($item)
    Widget:SetEntryState $entry normal

    set help [qdial:get_help $entry]
    bind $entry <FocusIn> [list qdial:show_help $help]
}

proc qdial:menu_entry {entry item itemlist} {
    MenuEntry $entry -variable PPxPVar($item) -items $itemlist

    set help [qdial:get_help $entry]
    bind [$entry subwidget entry]  <FocusIn> [list qdial:show_help $help]
    bind [$entry subwidget button] <FocusIn> [list qdial:show_help $help]
}

proc qdial:updown_entry {entry item} {
    UpDownEntry $entry -variable PPxPVar($item) -minimum 0

    set help [qdial:get_help $entry]
    bind [$entry subwidget entry] <FocusIn> [list qdial:show_help $help]
}

proc qdial:yesno_entry {entry item} {
    set f [frame $entry]
    radiobutton $f.yesButton -text yes -value yes -variable PPxPVar($item)
    radiobutton $f.noButton -text no -value no -variable PPxPVar($item)
    pack $f.yesButton $f.noButton -side left
}

proc qdial:ip_entry {entry item} {
    IpEntry $entry -variable PPxPVar($item) -minimum 0

    set help [qdial:get_help $entry]
    bind $entry <FocusIn> [list qdial:show_help $help]
}

proc qdial:passwd_fake {w k} {
    if {[string length $k] > 0 && [string length [$w get]] == 0} {
	$w insert end "\034\034\034\034\034\034\034\034\034\034\034\034\034\034\034\034\034\034\034\034"
    }
}

proc qdial:passwd_strip {p} {
    regsub -all "\034" $p {} passwd
    return $passwd
}

proc qdial:passwd_entry {entry item} {
    qdial:normal_entry $entry $item
    $entry configure -show *

    bind $entry <Key> {qdial:passwd_fake %W %A}

    foreach i {Control Meta Alt} {
	bind $entry <$i-Key> {return}
    }
    foreach i {Return Tab Delete} {
	bind $entry <Key-$i> {return}
    }
}

set qdial_show_log 0

proc qdial:standard_page {page} {
    frame $page

    label $page.deviceLabel
    label $page.dialLabel
    label $page.numberLabel
    label $page.nameLabel
    label $page.passwd1Label
    label $page.passwd2Label

    global qdial_device_list
    qdial:menu_entry $page.deviceEntry LINE $qdial_device_list
    qdial:menu_entry $page.dialEntry DIAL.TYPE {
	Tone Pulse Data Isdn Piafs none
    }
    $page.dialEntry configure -state buttononly
    qdial:normal_entry $page.numberEntry DIAL.LIST
    qdial:normal_entry $page.nameEntry user
    qdial:passwd_entry $page.passwd1Entry passwd1
    qdial:passwd_entry $page.passwd2Entry passwd2

    checkbutton $page.showLogButton -variable qdial_show_log

    grid $page.deviceLabel  -column 0 -row 0 -sticky e
    grid $page.dialLabel    -column 0 -row 1 -sticky e
    grid $page.numberLabel  -column 0 -row 2 -sticky e
    grid $page.nameLabel    -column 0 -row 3 -sticky e
    grid $page.passwd1Label -column 0 -row 4 -sticky e
    grid $page.passwd2Label -column 0 -row 5 -sticky e

    grid $page.deviceEntry  -column 1 -row 0 -sticky ew
    grid $page.dialEntry    -column 1 -row 1 -sticky ew
    grid $page.numberEntry  -column 1 -row 2 -sticky ew
    grid $page.nameEntry    -column 1 -row 3 -sticky ew
    grid $page.passwd1Entry -column 1 -row 4 -sticky ew
    grid $page.passwd2Entry -column 1 -row 5 -sticky ew

    grid $page.showLogButton -column 0 -row 6 -sticky e -columnspan 2
}

proc qdial:more_page {page} {
    set f [frame $page]

    label $f.authLabel
    label $f.modeLabel
    label $f.modemLabel
    label $f.idleLabel
    label $f.ipmasqLabel
    label $f.vjLabel

    qdial:menu_entry $f.authEntry AUTH.PROTO {
	{PAP CHAP/MD5 CHAP/MS} PAP CHAP/MD5 CHAP/MS none
    }
    qdial:menu_entry $f.modeEntry MODE {active passive kick}
    $f.modeEntry configure -state buttononly
    qdial:menu_entry $f.modemEntry SERIAL.MODEM [Modem:List]
    qdial:updown_entry $f.idleEntry IDLE.INIT
    qdial:ip_entry $f.ipmasqEntry ipmasq
    qdial:yesno_entry $f.vjEntry IP.VJ

    grid $f.authLabel   -column 0 -row 0 -sticky e
    grid $f.modeLabel   -column 0 -row 1 -sticky e
    grid $f.modemLabel  -column 0 -row 2 -sticky e
    grid $f.idleLabel   -column 0 -row 3 -sticky e
    grid $f.ipmasqLabel -column 0 -row 4 -sticky e
    grid $f.vjLabel     -column 0 -row 5 -sticky e

    grid $f.authEntry   -column 1 -row 0 -sticky ew
    grid $f.modeEntry   -column 1 -row 1 -sticky ew
    grid $f.modemEntry  -column 1 -row 2 -sticky ew
    grid $f.idleEntry   -column 1 -row 3 -sticky ew
    grid $f.ipmasqEntry -column 1 -row 4 -sticky ew
    grid $f.vjEntry     -column 1 -row 5 -sticky ew
}

proc qdial:dns_page {page} {
    set f [frame $page]

    LabelFrame $f.resolvFrame
    $f.resolvFrame label $f.resolvFrame.label
    set g [$f.resolvFrame subwidget frame]

    radiobutton $g.resolvNoButton  -variable PPxPVar(IP.RESOLV) -value no
    radiobutton $g.resolvYesButton -variable PPxPVar(IP.RESOLV) -value yes
    radiobutton $g.resolvFixButton -variable PPxPVar(IP.RESOLV) -value fix

    set help [option get $f.resolvFrame helpText {}]
    regsub -all {\\n} $help "\n" help
    bind $g <Expose> [list qdial:show_help $help]

    pack $g.resolvNoButton $g.resolvYesButton $g.resolvFixButton -side left

    LabelFrame $f.dnsFrame
    $f.dnsFrame label $f.dnsFrame.label
    set g [$f.dnsFrame subwidget frame]

    label $g.domainLabel
    label $g.dnsServer1Label
    label $g.dnsServer2Label
    label $g.dnsServer3Label

    qdial:normal_entry $g.domainEntry IP.DOMAIN
    IpEntry $g.dnsServer1Entry -netmaskon 0 -variable qdial_dns_1
    IpEntry $g.dnsServer2Entry -netmaskon 0 -variable qdial_dns_2
    IpEntry $g.dnsServer3Entry -netmaskon 0 -variable qdial_dns_3

    qdial:split_dns_servers
    PPxP:UpdateVarWidget $g IP.DNS qdial:split_dns_servers

    grid $g.domainLabel     -column 0 -row 0 -sticky e
    grid $g.dnsServer1Label -column 0 -row 1 -sticky e
    grid $g.dnsServer2Label -column 0 -row 2 -sticky e
    grid $g.dnsServer3Label -column 0 -row 3 -sticky e
    grid $g.domainEntry     -column 1 -row 0 -sticky w
    grid $g.dnsServer1Entry -column 1 -row 1 -sticky w
    grid $g.dnsServer2Entry -column 1 -row 2 -sticky w
    grid $g.dnsServer3Entry -column 1 -row 3 -sticky w

    pack $f.resolvFrame $f.dnsFrame -side top -fill x -expand yes
}

proc qdial:split_dns_servers {} {
    global PPxPVar qdial_dns_1 qdial_dns_2 qdial_dns_3

    set qdial_dns_1 [lindex $PPxPVar(IP.DNS) 0]
    set qdial_dns_2 [lindex $PPxPVar(IP.DNS) 1]
    set qdial_dns_3 [lindex $PPxPVar(IP.DNS) 2]
}

proc qdial:join_dns_servers {} {
    global qdial_dns_1 qdial_dns_2 qdial_dns_3

    set list {}
    if {$qdial_dns_1 != ""} {lappend list $qdial_dns_1}
    if {$qdial_dns_2 != ""} {lappend list $qdial_dns_2}
    if {$qdial_dns_3 != ""} {lappend list $qdial_dns_3}

    return $list
}

proc qdial:input_frame {frame} {
    frame $frame

    set f [NoteBook $frame.notebook]

    $f add $f.standardPage -tag [option get $f tag1 {}]
    $f add $f.morePage     -tag [option get $f tag2 {}]
    $f add $f.dnsPage      -tag [option get $f tag3 {}]

    $f.standardPage configure
    $f.morePage     configure
    $f.dnsPage      configure

    qdial:standard_page $frame.notebook.standardPage.frame
    pack $frame.notebook.standardPage.frame -padx 10 -pady 10

    qdial:more_page $frame.notebook.morePage.frame
    pack $frame.notebook.morePage.frame -padx 10 -pady 10

    qdial:dns_page $frame.notebook.dnsPage.frame
    pack $frame.notebook.dnsPage.frame -padx 10 -pady 10

    qdial:help_window $frame.help

    pack $frame.notebook -side left
    pack $frame.help -side left -fill both -expand yes
}

proc qdial:button_frame {frame} {
    set f [frame $frame]

    button $f.connectButton -command qdial:connect
    button $f.disconnectButton -command qdial:disconnect
    button $f.applyButton -command qdial:apply
    button $f.saveButton -command qdial:save
    button $f.closeButton -command [list Toplevel:Close  $f]
    button $f.quitButton -command [list Toplevel:Quit $f]

    grid $f.connectButton    -column 0 -row 0
    grid $f.disconnectButton -column 0 -row 0
    grid $f.applyButton      -column 1 -row 0
    grid $f.saveButton       -column 2 -row 0
    grid $f.closeButton      -column 3 -row 0

    if {[winfo toplevel $f] == "."} {
	grid $f.quitButton -column 4 -row 0
    }
    qdial:set_connect_button $f.connectButton $f.disconnectButton
    PPxP:UpdateStatusWidget $f \
	[list qdial:set_connect_button $f.connectButton $f.disconnectButton]
}

proc qdial:set_connect_button {con_button discon_button} {
    global PPxPStatus

    if {$PPxPStatus > 0} {
	grid remove $con_button
	grid $discon_button
    } else {
	grid remove $discon_button
	grid $con_button
    }
}

proc qdial:status_frame {frame} {
    set f [frame $frame]

    set l [label $f.statusLabel]
    set message_list [list \
	[option get $l deadMessage {}]    \
	[option get $l dialMessage {}]    \
	[option get $l chatMessage {}]    \
	[option get $l authMessage {}]    \
	[option get $l networkMessage {}] \
	[option get $l termMessage {}]]
    PPxP:UpdateStatusWidget $l [list qdial:show_status $l $message_list]

    label $f.connectTimeLabel
    PPxP:UpdateInfoWidget $f.connectTimeLabel connect \
	[list qdial:show_connect_time $f.connectTimeLabel]

    pack $f.statusLabel -side left -fill x -expand yes
    pack $f.connectTimeLabel -side left
}

proc qdial:show_status {label message_list} {
    global PPxPStatus
    $label configure -text [lindex $message_list $PPxPStatus]
}

proc qdial:show_connect_time {label} {
    $label configure -text [PPxP:ConnectTime]
}

proc qdial:comm_frame {frame} {
    frame $frame

    qdial:button_frame $frame.buttons
    qdial:status_frame $frame.status
    pack $frame.buttons -side left
    pack $frame.status -side left -fill x -expand yes
}

proc qdial:inputs_ok {} {
    global qdial_toplevel
    global PPxPVar

    if {
	$PPxPVar(LINE)      != "" &&
	$PPxPVar(DIAL.LIST) != "" &&
	$PPxPVar(DIAL.TYPE) != "" &&
	$PPxPVar(passwd1)   != "" &&
	$PPxPVar(passwd2)   != ""
    } {
	set passwd1 [qdial:passwd_strip $PPxPVar(passwd1)]
	set passwd2 [qdial:passwd_strip $PPxPVar(passwd2)]
	if {$passwd1 != $passwd2} {
	    tk_messageBox -type ok -message \
		[option get $qdial_toplevel passwdErrorMessage {}]
	    return 0
	} else {
	    return 1
	}
    } else {
	tk_messageBox -type ok -message \
	    [option get $qdial_toplevel blankItemMessage {}]
	return 0
    }
}

proc qdial:apply1 {item} {
    global PPxP PPxPVar

    if {$PPxPVar($item) != ""} {
	eval $PPxP set $item $PPxPVar($item)
    }
}

proc qdial:apply_passwd {name} {
    global PPxP PPxPVar

    if {
	$PPxPVar(passwd1) != "" && $PPxPVar(passwd2) != "" &&
	$PPxPVar(user) != ""
    } {
	set passwd1 [qdial:passwd_strip $PPxPVar(passwd1)]
	set passwd2 [qdial:passwd_strip $PPxPVar(passwd2)]
	if {$passwd1 == $passwd2} {
	    $PPxP passwd $name $PPxPVar(user) $passwd1
	}
    }
}

proc qdial:apply_ipmasq {} {
    global PPxP PPxPVar

    if {[info exists PPxPVar(ipmasq)] && $PPxPVar(ipmasq) != ""} {
	$PPxP filter ip  +mO -S $PPxPVar(ipmasq)
    }
}

proc qdial:apply {} {
    global PPxP PPxPVar

    $PPxP set CHAT none
    $PPxP source qdial

    if {![qdial:inputs_ok]} {
	return
    }
    qdial:apply1 LINE
    qdial:apply1 SERIAL.MODEM
    qdial:apply1 DIAL.TYPE
    qdial:apply1 DIAL.LIST
    qdial:apply1 AUTH.PROTO
    qdial:apply1 MODE
    qdial:apply1 IDLE.INIT
    qdial:apply1 IP.VJ

    qdial:apply1 IP.RESOLV
    qdial:apply1 IP.DOMAIN

    set PPxPVar(IP.DNS) [qdial:join_dns_servers]
    qdial:apply1 IP.DNS

    qdial:apply_passwd {}
    qdial:apply_ipmasq
}

proc qdial:connect {} {
    global PPxP qdial_show_log

    if {![qdial:inputs_ok]} {
	return
    }
    qdial:apply
    if $qdial_show_log {
	Log:Start 0
    }
    $PPxP connect
}

proc qdial:disconnect {} {
    global PPxP
    $PPxP disconnect
}

proc qdial:save1 {file item} {
    global PPxPVar

    if {$PPxPVar($item) != ""} {
	puts $file "set $item $PPxPVar($item)"
    }
}

proc qdial:save {} {
    global PPxPVar PPxP_UsrPath PPxP_SysPath

    if {![qdial:inputs_ok]} {
	return
    }
    if [info exists PPxP_UsrPath] {
	set path $PPxP_UsrPath
    } else {
	set path $PPxP_SysPath
    }
    set confdir [file join $path conf]
    set fname [tk_getSaveFile -initialdir $confdir]
    if {$fname == ""} {
	return
    }
    set name [file tail $fname]

    qdial:apply_passwd $name

    set f [open $fname w]
    puts $f "source qdial"
    qdial:save1 $f MODE
    puts $f "set AUTH.PASSWD $name"
    puts $f "set LOG.FILE ${name}.log"

    qdial:save1 $f LINE
    qdial:save1 $f DIAL.TYPE
    qdial:save1 $f DIAL.LIST
    qdial:save1 $f AUTH.PROTO
    if {$PPxPVar(SERIAL.MODEM) != ""} {
	set PPxPVar(SERIAL.MODEM) [lindex [split $PPxPVar(SERIAL.MODEM)] 0]
    }
    qdial:save1 $f SERIAL.MODEM
    qdial:save1 $f IDLE.INIT
    qdial:save1 $f IP.VJ

    qdial:save1 $f IP.RESOLV
    qdial:save1 $f IP.DOMAIN

    set PPxPVar(IP.DNS) [qdial:join_dns_servers]
    qdial:save1 $f IP.DNS

    if {[info exists PPxPVar(ipmasq)] && $PPxPVar(ipmasq) != ""} {
	puts $f "filter ip +mO -S $PPxPVar(ipmasq)"
    }
    close $f
}

proc qdial:start_window {w args} {
    qdial:title_frame $w.title
    qdial:input_frame $w.input
    qdial:comm_frame  $w.comm

    pack $w.title -side top -fill x
    pack $w.input -side top -fill both -expand yes
    pack $w.comm  -side top -fill x

    $w.input.notebook fixsize 1
    $w.input.notebook select $w.input.notebook.standardPage

    global PPxP
    $PPxP source qdial
    foreach i {LINE SERIAL.MODEM DIAL.TYPE DIAL.LIST AUTH.PROT MODE
    IDLE.IDLE MODE IDLE.INIT AUTH.PASSWD} {
	$PPxP env $i
    }
}

proc Qdial:Start {main_flag} {
    Toplevel:Start .tkppxpQdial Qdial "PPxP Quick Dialup" $main_flag \
	qdial:start_window {}
}
