#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>

#include "fppxp.h"

#include <support.h>
#include <xcio.h>
#include <ppxp.h>

#define	laddrObj	(ipObjs[0])
#define	raddrObj	(ipObjs[1])
#define	maddrObj	(ipObjs[2])
#define	vjObj		(ipObjs[3])
#define	applyObj	(ipObjs[4])
#define	resetObj	(ipObjs[5])
static FL_OBJECT *ipObjs[6];

#define	NUM_IPOBJS	(sizeof(ipObjs)/sizeof(ipObjs[0]))

#define	ADDR_HEIGHT	17
#define	ADDR_WIDTH	150

#define	APPLY_HEIGHT	20
#define	APPLY_WIDTH	50

#define	RESET_HEIGHT	20
#define	RESET_WIDTH	50

#define	VJ_HEIGHT	22
#define	VJ_WIDTH	22

static nlpstat_t nlpStat;

static void
IpRefresh()
{
    extern char *XcGetEnv();
    unsigned int m, n, i;
    char *mask, addr[36];

/*    strcpy(addr, GetEnvValue("IP.LOCAL"));*/
    strcpy(addr, XcGetEnv("IP.LOCAL"));
    if ((mask = strchr(addr, '/')) != NULL) {
	*mask = '\0';
	mask ++;
	m = inet_addr(mask);
	for (n = i = 0; i < 32; i ++) {
	    if (m & 1) n ++;
	    m >>= 1;
	}
    } else n = 0;
    fl_set_ipinput(laddrObj, inet_addr(addr), n);

/*    strcpy(addr, GetEnvValue("IP.REMOTE"));*/
    strcpy(addr, XcGetEnv("IP.REMOTE"));
    if ((mask = strchr(addr, '/')) != NULL) {
	*mask = '\0';
	mask ++;
	m = inet_addr(mask);
	for (n = i = 0; i < 32; i ++) {
	    if (m & 1) n ++;
	    m >>= 1;
	}
    } else n = 0;
    fl_set_ipinput(raddrObj, inet_addr(addr), n);

/*    strcpy(addr, GetEnvValue("IP.NETMASK"));*/
    strcpy(addr, XcGetEnv("IP.NETMASK"));
    fl_set_ipinput(maddrObj, inet_addr(addr), 0);

/*    strcpy(addr, GetEnvValue("IP.VJ"));*/
    strcpy(addr, XcGetEnv("IP.VJ"));
    fl_set_button(vjObj, strstr(addr, "yes") ? 1: 0);
}

void
UpdateIpPanel(struct pppinfo_s *old, struct pppinfo_s *new)
{
    if ((nlpStat & NSTAT_IP) != (new->n_stat & NSTAT_IP)) {
	unsigned int i;

/*	XcEnvCommand("ip", IpRefresh);*/
	IpRefresh();
	if (new->n_stat & NSTAT_IP) {
	    for (i = 0; i < NUM_IPOBJS; i ++)
		fl_deactivate_object(ipObjs[i]);
	    fl_hide_object(applyObj);
	    fl_hide_object(resetObj);
	} else {
	    for (i = 0; i < NUM_IPOBJS; i ++)
		fl_activate_object(ipObjs[i]);
	    fl_show_object(applyObj);
	    fl_show_object(resetObj);
	}
    }
    nlpStat = new->n_stat;
}

static void
BtnsCallBack(FL_OBJECT *obj, long arg)
{
    if (arg) {
/*	XcEnvCommand("ip", IpRefresh);*/
	IpRefresh();
    } else {
	char buf[40];
	struct in_addr in;

	if (fl_apply_ipinput(laddrObj)) {
	    in.s_addr = fl_get_ipinput_addr(laddrObj);
	    sprintf(buf, "%s/%d", inet_ntoa(in),
		    fl_get_ipinput_mask(laddrObj));
	    XcCommand(XCMD_SET, NULL, "IP.LOCAL", buf, NULL);
	}
	if (fl_apply_ipinput(raddrObj)) {
	    in.s_addr = fl_get_ipinput_addr(raddrObj);
	    sprintf(buf, "%s/%d", inet_ntoa(in),
		    fl_get_ipinput_mask(raddrObj));
	    XcCommand(XCMD_SET, NULL, "IP.REMOTE", buf, NULL);
	}
	if (fl_apply_ipinput(maddrObj)) {
	    in.s_addr = fl_get_ipinput_addr(maddrObj);
	    sprintf(buf, "%s", inet_ntoa(in));
	    XcCommand(XCMD_SET, NULL, "IP.NETMASK", buf, NULL);
	}

	sprintf(buf, "%s",
		fl_get_button(vjObj) ? "yes": "no");
	XcCommand(XCMD_SET, NULL, "IP.VJ", buf, NULL);
    }
}

void
ActivateIpPanel(int sw)
{
    unsigned int i;

    for (i = 0; i < NUM_IPOBJS; i ++) {
	if (sw) {
	    if (!(nlpStat & NSTAT_IP)) fl_activate_object(ipObjs[i]);
	    if (!(nlpStat & NSTAT_IP)
		|| (ipObjs[i] != applyObj && ipObjs[i] != resetObj))
		fl_show_object(ipObjs[i]);
	} else {
	    fl_deactivate_object(ipObjs[i]);
	    fl_hide_object(ipObjs[i]);
	}
    }
}

FL_OBJECT **
CreateIpPanel(int x, int y, int w, int h)
{
    FL_OBJECT *obj;
    int dx, dy;
    unsigned int n=0, width;

    width = (w - (FRAME_GAP << 1));

    dx = x + 50;
    dy = y;
    width -= 100;
    obj = fl_add_ipinput(FL_MASKBITS_IPINPUT, dx + FRAME_GAP,
			 dy + FRAME_GAP, ADDR_WIDTH, ADDR_HEIGHT,
			 "Local:");
    fl_set_object_color(obj, FL_WHITE, FL_COL1);
    fl_set_object_boxtype(obj, FL_DOWN_BOX);
    ipObjs[n ++] = obj;

    dy += ADDR_HEIGHT + obj->bw;
    obj = fl_add_ipinput(FL_MASKBITS_IPINPUT, dx + FRAME_GAP,
			 dy + FRAME_GAP, ADDR_WIDTH, ADDR_HEIGHT,
			 "Remote:");
    fl_set_object_color(obj, FL_WHITE, FL_COL1);
    fl_set_object_boxtype(obj, FL_DOWN_BOX);
    ipObjs[n ++] = obj;

    dy += ADDR_HEIGHT + obj->bw;
    obj = fl_add_ipinput(FL_NORMAL_IPINPUT, dx + FRAME_GAP,
			 dy + FRAME_GAP, ADDR_WIDTH - 30, ADDR_HEIGHT,
			 "Mask:");
    fl_set_object_color(obj, FL_WHITE, FL_COL1);
    fl_set_object_boxtype(obj, FL_DOWN_BOX);
    ipObjs[n ++] = obj;

    /* Buttons */

    dy += ADDR_HEIGHT + obj->bw;
    obj = fl_add_checkbutton(FL_PUSH_BUTTON, x + 40, dy + FRAME_GAP,
			     VJ_WIDTH, VJ_HEIGHT,
			     "VJ header compression");
    fl_set_object_color(obj, FL_MCOL, FL_CYAN);
    ipObjs[n ++] = obj;

    dx = x + w - APPLY_WIDTH - RESET_WIDTH - (FRAME_GAP << 1);
    dy = y + h - APPLY_HEIGHT - FRAME_GAP;

    obj = fl_add_button(FL_NORMAL_BUTTON, dx, dy,
			APPLY_WIDTH, APPLY_HEIGHT, "Apply");
    fl_set_object_callback(obj, BtnsCallBack, 0);
    ipObjs[n ++] = obj;

    dx += APPLY_WIDTH + FRAME_GAP;
    obj = fl_add_button(FL_NORMAL_BUTTON, dx, dy,
			RESET_WIDTH, RESET_HEIGHT, "Reset");
    fl_set_object_callback(obj, BtnsCallBack, 1);
    ipObjs[n ++] = obj;

/*    XcEnvCommand("ip", IpRefresh);*/
	IpRefresh();
    return(ipObjs);
}

