/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#if defined unicos || defined SunOS
#include <fcntl.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#include <sys/time.h>
#include "main.h"

extern void set_tty(int);
extern short get_var_from_pftprc(FILE *, const char *, char *, int);
extern void import(unsigned long, double *, int);
extern void timing(int, double *, char *);
extern char *time_string(void);
extern short check_pass(int);
extern char *tabdir(char *);
extern void receive_udps(int strnum, double *);
extern void find_free_name(char *, char *);
extern int get_file_status(int, pftp_file_status *);
extern int skip_upper_dirs(int, int, int);
extern void send_oob_error(int, char *);
extern int check_dir_size(int, double *);
#if defined Linux && defined USE_POSIX_THREAD
extern void signal_handling(int);
#endif

extern void test_the_net_read(int, double *);
static double sum_bytes[MAXCLIENTS+1];

void receive_data(void *structure_number)
{
   char fstr[HUNAME], ch[1];
   char *strptr=NULL;
   pftp_file_status pfs;
   struct stat buf;
   size_t BUFFER_SIZE = (*statstr)->_STDIN_BUFSIZ_ ? (*statstr)->_STDIN_BUFSIZ_: DEFAULT_STRING_SIZE;
   char bstr[BIG_BUFSIZE];
   register ssize_t cc, check;
   double filesize=0;
   double ci=0; /* number of bytes received */
   int strnum = (int)*(int *)structure_number;
   int mode=0, smode=0755;
   int appending=0;
   int ft=1;
   int h=0;
   int fd = (*(statstr+strnum))->fd;
   unsigned char FIRST=1, hor=0, dont_write=0;

#ifndef Linux
   if (BUFFER_SIZE > BIG_BUFSIZE) BUFFER_SIZE = BIG_BUFSIZE;
#endif

   if ((*statstr)->_PFTP_DAEMON_) {
      /*
       * Check password if server is running
       * as daemon or was started by inetd.
       */
       if (!check_pass(strnum)) return;

      /*
       * Look if PFTPRENAME is set.
       */
      if (get_var_from_pftprc((FILE *)NULL, "PFTPRENAME", bstr, strnum)) {
         (*(statstr+strnum))->rename = atoi(bstr)? 1: 0;
      }

      /*
       * Look if PFTPAINFO is set.  Should be set to 1 by default.
       */
      (*(statstr+strnum))->accept_file_info = 1;
      if (get_var_from_pftprc((FILE *)NULL, "PFTPAINFO", bstr, strnum)) {
         (*(statstr+strnum))->accept_file_info = atoi(bstr)? 1: 0;
      }
   }
   else if (!(*(statstr+strnum))->accept_file_info) {
      /*
       * Look if PFTPSINFO is set.
       */
      if (get_var_from_pftprc((FILE *)NULL, "PFTPSINFO", bstr, strnum)) {
         (*(statstr+strnum))->accept_file_info = atoi(bstr)? 1: 0;
      }
   }

   /*
    * Start timing.
    */
   *(sum_bytes+strnum) = 0;
   if (!(*statstr)->use_udp) {
      timing(strnum, sum_bytes+strnum, NULL);
      (*(statstr+strnum))->first = BIT_ONE;
   }

   /*
    * Handle special output.
    */
   if ((*statstr)->FORCE_STDOUT) dont_write = 1;
   if ((*statstr)->testbsize) { dont_write = 1; close(1); }
   if ((*statstr)->use_udp) dont_write = 1;

   do {
      /*
       * Get some information about the file.
       */
      *((*(statstr+strnum))->cwd_last_ch) = '\0';
      if (!(*statstr)->use_udp) {
         for (h=0, strptr=fstr; h < HUNAME && read(fd, ch, sizeof(ch)); h++, strptr++) {
            *strptr = *ch;
            if (*strptr == '\n') break;
         }
         if (*strptr != '\n') continue;
         *strptr = '\0';
         if (!*fstr) continue;
         else {
            if (((*(statstr+strnum))->first & BIT_ONE)) timing(strnum, sum_bytes+strnum, NULL);
            pfs.name = (*(statstr+strnum))->cwd_last_ch;
            pfs.input = fstr;
            pfs.end = strptr;

            if (!(cc = get_file_status(strnum, &pfs)) || !read(fd, ch, sizeof(ch)) || ('H' != *ch)) {
               if (pfs.mode < 0) break;
               send((*(statstr+strnum))->ws, PFTP_WRONG_PROT, PFTP_WRONG_PROT_LEN, MSG_OOB);
               if (slfp) {
                  if ((*(statstr+strnum))->_PFTP_DAEMON_) {
                     fprintf(slfp, "%s for %s wrong protocol from %s\n", \
                     time_string(), (*(statstr+strnum))->pw_name, \
                     (*(statstr+strnum))->REMOTEHOSTNAME);
                  }
                  else {
#ifdef USE_POSIX_THREAD
                     if (CHILDNUM > 1 && (*statstr)->RECEIVING) {
                        putc('\n', slfp);
                     }
#else
                     putc('\n', slfp);
#endif
                     fprintf(slfp, "** Wrong protocol from %s.\n",\
                     (*(statstr+strnum))->REMOTEHOSTNAME);
                  }
               }
               return;
            }
            /*
             * Continue if directory information was sent.
             */
            if (cc == 2) continue;
            /*
             * Return if directory information couldn't be set.
             */
            if (cc == 3) return;
            filesize = pfs.size;
            if (*((*(statstr+strnum))->from) && (*(statstr+strnum))->mul) {
               if (!check_dir_size(strnum, &filesize)) return;
            }
            mode = pfs.mode;
            umask(~mode);
            umask(~smode);
         }

         if ((*(statstr+strnum))->_SKIP_ == 3) (*(statstr+strnum))->_SKIP_ = 0;
         else if ((*(statstr+strnum))->_SKIP_) (*(statstr+strnum))->_SKIP_ = 1;

         if (!(*statstr)->_PFTP_DAEMON_ && FIRST && slfp == stderr) {
#ifdef USE_POSIX_THREAD
            pthread_mutex_lock(&interactiv);
            if (CHILDNUM == 1) putc('\r', slfp);
            else if ((*statstr)->RECEIVING) putc('\n', slfp);
            pthread_mutex_unlock(&interactiv);
#else
            putc('\n', slfp);
#endif
         }
         FIRST = 0;

         /*
          * Check for remote standard input stream.
          */
         if (!dont_write && (!strcmp((*(statstr+strnum))->cwd_last_ch, "|")) \
            && (*(statstr+strnum))->_STANDARD_INPUT_) {
            ft = 1;
            strcpy((*(statstr+strnum))->cwd_last_ch, "Stream");
         }
         /*
          * Check for regular file.
          */
         else {
            /*
             * Check and create file name and directories.
             */
            if (!strcmp((*(statstr+strnum))->cwd_last_ch, "|")) {
               /*
                * Take another number if file already exists.
                */
               if (!(*statstr)->testbsize) {
                  find_free_name("Stream", bstr);
                  strcpy((*(statstr+strnum))->cwd_last_ch, bstr);
               }
               else strcpy((*(statstr+strnum))->cwd_last_ch, "stream");
            }

            /*
             * Skip upper directories and create needed
             * directories if statstr's _RECURS_ is set.
             */
            if (!skip_upper_dirs(strnum, dont_write, smode)) return;

            /*
             * Check existence of file on local host.
             */
            while (!access((*(statstr+strnum))->cwd, F_OK) && !dont_write) {
               if ((*(statstr+strnum))->rename) {
                  find_free_name((*(statstr+strnum))->cwd, bstr);
                  strcpy((*(statstr+strnum))->cwd, bstr);
                  *bstr = '\0';
                  break;
               }
               else if ((*(statstr+strnum))->_SKIP_) {
                  (*(statstr+strnum))->_SKIP_ = 2;
                  break;
               }
               else if ((*(statstr+strnum))->OVERWRITE) {
                  appending = O_TRUNC;
                  if (stat((*(statstr+strnum))->cwd, &buf)) {
                     send_oob_error(strnum, (*(statstr+strnum))->cwd_last_ch);
                     return;
                  }
                  else if ((buf.st_mode & 0200) != 0200) {
                     if (chmod((*(statstr+strnum))->cwd, mode|0200) < 0) {
                        send_oob_error(strnum, (*(statstr+strnum))->cwd_last_ch);
                        return;
                     }
                  }
                  break;
               }
#ifdef USE_POSIX_THREAD
               pthread_mutex_lock(&interactiv);
#endif
               fprintf(stderr, "** File %s exists! (from %s)\n** Overwrite(y|n) all(Y), append(a), rename(r), skip(s) all(S)? ", (*(statstr+strnum))->cwd_last_ch, (*(statstr+strnum))->REMOTEHOSTNAME);
#if defined Linux
               if ((*statstr)->ttys) {
#ifdef USE_POSIX_THREAD
                  signal_handling((SET_SIG_SIGIO | IGN_SIGNAL));
#else
                  if (!(*statstr)->single_connection) kill(getppid(), SIGUSR1);
                  set_tty(1);
#endif
               }
#else
               set_tty(1);
#endif
               hor=fgetc(stdin);
#ifdef Linux
#ifndef USE_POSIX_THREAD
               if ((*statstr)->ttys) {
                  set_tty(2);
               }
#endif
#else
               set_tty(0);
#endif
               fprintf(stderr, "\r                                                               \r");
               if(hor=='Y' || hor=='y' || hor=='a') {
                  if (stat((*(statstr+strnum))->cwd, &buf)) {
                     send_oob_error(strnum, (*(statstr+strnum))->cwd_last_ch);
#ifdef USE_POSIX_THREAD
                     pthread_mutex_unlock(&interactiv);
#endif
                     return;
                  }
                  else if ((buf.st_mode & 0200) != 0200) {
                     if (chmod((*(statstr+strnum))->cwd_last_ch, mode|0200) < 0) {
                        send_oob_error(strnum, (*(statstr+strnum))->cwd_last_ch);
#ifdef USE_POSIX_THREAD
                        pthread_mutex_unlock(&interactiv);
#endif
                        return;
                     }
                  }
                  if (hor=='Y') (*(statstr+strnum))->OVERWRITE = BIT_ONE;
                  else if (hor=='a') appending = O_APPEND;
                  if (hor!='a') appending = O_TRUNC;
#ifdef USE_POSIX_THREAD
                  pthread_mutex_unlock(&interactiv);
#endif
                  break;
               }
               else if(hor=='s') {
                  (*(statstr+strnum))->_SKIP_ = 3;
#ifdef USE_POSIX_THREAD
                  pthread_mutex_unlock(&interactiv);
#endif
                  break;
               }
               else if(hor=='S') {
                  (*(statstr+strnum))->_SKIP_ = 2;
#ifdef USE_POSIX_THREAD
                  pthread_mutex_unlock(&interactiv);
#endif
                  break;
               }
               else if (hor=='r') {
                  find_free_name((*(statstr+strnum))->cwd_last_ch, bstr);
                  strcpy((*(statstr+strnum))->cwd_last_ch, bstr);
                  *bstr = '\0';
#ifdef USE_POSIX_THREAD
                  pthread_mutex_unlock(&interactiv);
#endif
                  break;
               }
               else {
                  char *str=NULL;
                  char *stmp=NULL;
                  MEM_CHECK((str = (char *)calloc(SONAME, sizeof(char))));
#ifdef NEXTSTEP
                  getwd(str);
#else
                  getcwd(str, SONAME);
#endif
#ifndef Linux
                  set_tty(2);
#endif
                  stmp = tabdir(str);
#ifndef Linux
                  set_tty(0);
#endif
                  fprintf(stderr, "\n");
                  if (!stat(stmp, &buf) && (buf.st_mode & S_IFDIR)) {
                     strcat(stmp, "/");
                     strcat(stmp, (*(statstr+strnum))->cwd_last_ch);
                  }
                  if (stmp) strcpy((*(statstr+strnum))->cwd, stmp);
                  free(str);
               }   
#if defined Linux
               if ((*statstr)->ttys) {
#ifdef USE_POSIX_THREAD
                  signal_handling((SET_SIG_SIGIO | SET_SERVER_HANDLER));
#else
                  if (!(*statstr)->single_connection) kill(getppid(), SIGUSR1);
#endif
                  hor = 0;
               }
#endif
#ifdef USE_POSIX_THREAD
               pthread_mutex_unlock(&interactiv);
#endif
            }
#if defined Linux
            if (hor) {
               hor = 0;
               if ((*statstr)->ttys) {
#ifdef USE_POSIX_THREAD
                  signal_handling((SET_SIG_SIGIO | SET_SERVER_HANDLER));
#else
                  if (!(*statstr)->single_connection) kill(getppid(), SIGUSR1);
#endif
               }
            }
#endif
            if ((*(statstr+strnum))->_SKIP_ < 2 && !dont_write) {
               /*
                * Open file on local host for writing.
                */
               if ((ft = open((*(statstr+strnum))->cwd, O_CREAT|O_WRONLY|appending, mode)) < 0) {
                  send_oob_error(strnum, (*(statstr+strnum))->cwd_last_ch);
                  return;
               }
               appending = 0;
            }
            else if ((*statstr)->FORCE_STDOUT) ft = 1;
         }

         ci=0.0;
         (*(statstr+strnum))->lol=0;
         if (!(*statstr)->_PFTP_DAEMON_ && slfp) {
#ifdef USE_POSIX_THREAD
            pthread_mutex_lock(&interactiv);
#endif
            import(filesize, &ci, strnum);
#ifdef USE_POSIX_THREAD
            pthread_mutex_unlock(&interactiv);
#endif
         }
      }
      else strcpy((*(statstr+strnum))->cwd_last_ch, "Datagrams");

      if ((*(statstr+strnum))->_SKIP_ > 1) {
         register int rr = (unsigned int)BUFFER_SIZE < filesize ? BUFFER_SIZE : filesize;
         while (ci < filesize && (cc = read(fd, bstr, rr)) > 0) {
            if ((ci+=(double)cc) > (filesize - (double)rr)) rr = (int)(filesize - ci);
         }
      }
      /*
       * Read file from client/filter and write to 
       * local file respectively standard out.
       */
      else if (filesize) {
         register int rr = (unsigned int)((double)BUFFER_SIZE < filesize) ? BUFFER_SIZE : filesize;
         double firr = filesize - (double)rr;
         while (ci < filesize && (cc = read(fd, bstr, rr)) > 0) {
            if ((ci+=(double)cc) > firr) rr = (int)(filesize - ci);
            for (check=0, strptr=bstr; cc; cc-=check, strptr += check) {
               if ((check = write(ft, strptr, cc)) < 0) {
                  send_oob_error(strnum, (*(statstr+strnum))->cwd_last_ch);
                  return;
               }
            }
         }
         if (pfs.info) {
            if (!getuid() && fchown(ft, pfs.uid, pfs.gid)) {
               send_oob_error(strnum, (*(statstr+strnum))->cwd_last_ch);
               close(ft);
               return;
            }
         }
      }
      else {
         if (!(*statstr)->use_udp) {
            if (!*((*(statstr+strnum))->from)) {
               if (!(*statstr)->testbsize) {
                  register int rr = BUFFER_SIZE;
                  if (!(*statstr)->_STDIN_BUFSIZ_) rr = 1;
                  for (ci=0, cc=0; (cc = read(fd, bstr, rr)) > 0;) {
                     ci+=(double)cc;
                     for (check=0, strptr=bstr; cc; cc-=check, strptr += check) {
                        if ((check = write(ft, strptr, cc)) < 0) {
                           send_oob_error(strnum, (*(statstr+strnum))->cwd_last_ch);
                           return;
                        }
                     }
                  }
               }
               else test_the_net_read(fd, &ci);
            }
            else {
               register int rr = BUFFER_SIZE;
               for (ci=0.0, cc=0; (cc = read(fd, bstr, rr)) > 0;) {
                  filesize = (double)cc;
                  if ((*(statstr+strnum))->mul && !check_dir_size(strnum, &filesize)) {
                     close(ft);
                     return;
                  }
                  filesize = 0;
                  ci+=(double)cc;
                  for (check=0, strptr=bstr; cc; cc-=check, strptr += check) {
                     if ((check = write(ft, strptr, cc)) < 0) {
                        send_oob_error(strnum, (*(statstr+strnum))->cwd_last_ch);
                        return;
                     }
                  }
               }
            }
         }
         /*
          * Handle UDP datagrams.
          */
         else receive_udps(strnum, &ci);
      }

      if (!ci) (*(statstr+strnum))->lol = 1;
      else *(sum_bytes+strnum) += ci;
      if ((*(statstr+strnum))->_SKIP_ < 2 && !(*statstr)->FORCE_STDOUT \
         && !(*(statstr+strnum))->_STANDARD_INPUT_) {
         close(ft);
         if (pfs.info) {
            if (utimes((*(statstr+strnum))->cwd, (struct timeval *)pfs.time)) {
               send_oob_error(strnum, (*(statstr+strnum))->cwd_last_ch);
               return;
            }
         }
      }
      if ((!((*statstr)->_PFTP_DAEMON_) || (*statstr)->lognames) && slfp) {
#ifdef USE_POSIX_THREAD
         pthread_mutex_lock(&interactiv);
#endif
         if (filesize) import(filesize, &ci, strnum);
         else import(filesize, sum_bytes+strnum, strnum);
#ifdef USE_POSIX_THREAD
         pthread_mutex_unlock(&interactiv);
#endif
      }

      /*
       * Check of size of file.
       */
      if (!(*statstr)->_PFTP_DAEMON_ && slfp && filesize > ci && filesize > 0.0) {
#ifdef USE_POSIX_THREAD
         pthread_mutex_lock(&interactiv);
#endif
         fprintf(slfp, "** File is incomplete. ");
         fprintf(slfp, "Actual size of file is %.0f bytes.\n", filesize);
#ifdef USE_POSIX_THREAD
         pthread_mutex_unlock(&interactiv);
#endif
      }
      ci = 0.0;
   } while (*((*(statstr+strnum))->cwd_last_ch) && !(*statstr)->use_udp);
   (*(statstr+strnum))->first = BIT_TWO;

   /*
    * End timing and calculate statistic.
    */
   timing(strnum, sum_bytes+strnum, fstr);

   /*
    * Send statistic.
    */
   if (!(*statstr)->use_udp && (*(sum_bytes+strnum) || (*(statstr+strnum))->fad_info)) {
      if (write((*(statstr+strnum))->ws, fstr, strlen(fstr)) < 0) {
         if (slfp && !(*statstr)->_PFTP_DAEMON_) {
            fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
         }
      }
   }
}
