/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#include "main.h"

extern int get_login_and_hostname(char *, int *);
extern void create_rc_file(char *);
extern void set_vars_from_pftprc(FILE *, int *, int);
extern int substitute_string(char *, int);


void shost(int *portn, int strnum)
{
   char *name=NULL, str[SONAME], *stra=NULL, *stre=NULL;
   FILE *fp=NULL;
   int i, port=0;
   int num=(*(statstr+strnum))->host_number;

   if (!(fp = fopen((*(statstr+strnum))->home, "r"))) {
      if (isatty(0)) create_rc_file((*(statstr+strnum))->home);
      exit(PFTP_OPEN_RC_ERR);
   }
   for (num++, i=1; i < num && fgets(str, SONAME, fp); i++) {
      for (stra=str; *stra && *stra != '\n' && *stra != '#'; stra++);
      *stra = '\0';
      for (stra=str; *stra && (*stra == ' ' || *stra == '\t'); stra++);

      /*
       * Skip variables and empty lines.
       */
      if (!*stra || !strncmp("PFTP", stra, 4)) i--;

      /*
       * Substitute string with variable or file contents.
       */
      if (*stra == PFTP_SPECIAL_SIGN && \
         (*(stra+1) == 'V' || *(stra+1) == 'F')) {
         substitute_string(str, stra-str);
      }

      /*
       * Skip lines which are recognized by the server
       * only.
       */
      if (*stra == PFTP_SPECIAL_SIGN || *stra == '.') i--;
   }

   /*
    * Get host name.
    */
   if (i == num) {
      MEM_CHECK((name = (char *) calloc(SONAME, sizeof(char))));
      for (stre=stra; *stre && *stre != ' ' && *stre != '\t'; stre++);
      *stre = '\0';
      for (stre++; *stre && (*stre == ' ' || *stre == '\t'); stre++);
      if (((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) port = INETD_PORT;
      else if (*stre) port = atoi(stre);
      strcpy(name, stra);
      if (get_login_and_hostname(name, (int *)NULL)) {
         if (slfp) fprintf(slfp, "** You entered an invalid hostname.\n");
         exit(PFTP_INVHOST_ERR);
      }
      /*
       *  Now let's look for host specific variables.
       */
      while (fgets(str, SONAME, fp)) {
         for (stra=str; *stra && *stra != '\n' && *stra != '#'; stra++);
         *stra = '\0';
         for (stra=str; *stra && (*stra == ' ' || *stra == '\t'); stra++);
         if (!*stra) continue;
         if (!strncmp("PFTP", stra, 4)) set_vars_from_pftprc(fp, portn, strnum);
         else break;
      }
   }
   else {
      fclose(fp);
      if (slfp) fprintf(slfp, "** Host number %d is not registered in your host name list!\n", (int)num-1);
      exit(PFTP_INVHOST_ERR);
   }

   /*
    * Set host name.
    */
   if (!(*(statstr+strnum))->_HOSTNAME_) {
      MEM_CHECK(((*(statstr+strnum))->_HOSTNAME_ = (char *) calloc(SONAME, sizeof(*name))));
   }
   strcpy((*(statstr+strnum))->_HOSTNAME_, name);

   free(name);

   if (port) *portn = port;
   fclose(fp);
}
