/*
  $Id: getmount.h,v 1.1 1996/08/10 13:38:38 luik Exp $

  getmount.h - operating system mount table access function definitions.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef GETMOUNT_H_INCLUDED
#define GETMOUNT_H_INCLUDED

#include <stdio.h>

#define GETMOUNT_UNKNOWN    0
#define GETMOUNT_BSD	    1
#define GETMOUNT_SYSV	    2

#if GETMOUNT_TYPE == GETMOUNT_BSD
# include <mntent.h>
# ifdef MOUNTED
#  define PATH_MTAB MOUNTED
# else /* !defined(MOUNTED) */
#  define PATH_MTAB "/etc/mtab"
# endif /* !defined(MOUNTED) */
#endif /* GETMOUNT_TYPE == GETMOUNT_BSD */

#if GETMOUNT_TYPE == GETMOUNT_SYSV
# include <sys/mnttab.h>
# ifdef MNTTAB
#  define PATH_MTAB MNTTAB
# else /* !defined(MNTTAB) */
#  define PATH_MTAB "/etc/mnttab"
# endif /* !defined(MNTTAB) */
#endif /* GETMOUNT_TYPE == GETMOUNT_SYSV */

#ifdef	__cplusplus
extern "C" {
#endif

struct mountent {
    char *fsname;		/* device/special */
    char *dir;			/* mount point */
    char *type;			/* filesystem type */
    char *opts;			/* mount options */
};

/* getmount.c */
extern FILE *setmountent(const char *filename, const char *type);
extern int endmountent(FILE *f);
extern struct mountent *getmountent(FILE *f);
extern struct mountent *getmountentbydev(dev_t dev);

#ifdef	__cplusplus
}
#endif

#endif /* defined(GETMOUNT_H_INCLUDED) */
