/*
  $Id: error.h,v 1.4 1996/08/18 12:05:33 luik Exp $

  error.h - declarations for omirrd error message routines.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef ERROR_H_INCLUDED
#define ERROR_H_INCLUDED

#include <syslog.h>

#if STDC_HEADERS
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifdef	__cplusplus
extern "C" {
#endif

/* error.c */
extern int errlog_stdout(int flag);
extern int errlog_stderr(int flag);
extern int errlog_file(int flag, char *filename);
extern int errlog_syslog(int flag);
#if HAVE_VPRINTF
extern void verrlog(int priority, const char *fmt, va_list ap);
#endif /* !HAVE_VPRINTF */
#if HAVE_VPRINTF && (STDC_HEADERS || !defined(NOVAPROTO))
extern void errlog(int priority, const char *fmt, ...);
extern void fatal(const char *fmt, ...);
extern void error(const char *fmt, ...);
extern void warning(const char *fmt, ...);
#else /* !STDC_HEADERS */
extern void errlog();
extern void fatal();
extern void error();
extern void warning();
#endif /* !STDC_HEADERS */

#ifdef	__cplusplus
}
#endif

#endif /* !defined(ERROR_H_INCLUDED) */

