/*
 *  Copyright (C) 1998-99 Luca Deri <deri@unipi.it>
 *                      
 *			  Centro SERRA, University of Pisa
 *			  http://www-serra.unipi.it/
 *  					
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ntop.h"

/* Extern */
extern int newSock;

#ifdef HAVE_GDBM_H
extern GDBM_FILE gdbm_file, pwFile;
#ifdef MULTITHREADED
extern pthread_mutex_t gdbmMutex;
#endif
#endif

extern void sendStringLen(char *theString, int len);
extern void sendHTTPProtoHeader();
extern void sendString(char *theString);

#ifdef HAVE_GDBM_H
void showUsers() {
  u_int numUsers=0;
  char buf[BUF_SIZE];
  datum key_data, return_data;

  sendString("<html>\n");
  sendString("<title>Welcome to ntop!</title>\n");
  sendString("</head><BODY BGCOLOR=#FFFFFF><FONT FACE=Helvetica>\n");
  sendString("<H1><CENTER>Registered ntop Users</CENTER></H1><p><hr><p>\n");

#ifdef MULTITHREADED
    accessMutex(&gdbmMutex);
#endif 
  return_data = gdbm_firstkey (pwFile);

  while (return_data.dptr != NULL) {
    /* printf("1) -> %s\n", return_data.dptr); */
    key_data = return_data;

    if(key_data.dptr[0] == '1') /* 1 = user */{

      if(numUsers == 0) {
	sendString("<center><TABLE BORDER>\n");
	sendString("<TR><TH>Users</TH><TH>Actions</TH></TR>\n");
      }
	
      sprintf(buf, "<TR><TH ALIGN=LEFT><IMG SRC=/user.gif>"
	      "&nbsp;%s</TH><TD><A HREF=/modifyUser?%s>"
	      "<IMG SRC=/modifyUser.gif BORDER=0 align=absmiddle></A>"
	      "&nbsp;<A HREF=/deleteUser?%s><IMG SRC=/deleteUser.gif BORDER=0 align=absmiddle>"
	      "</A></TD></TR></TH></TR>\n", &key_data.dptr[1], key_data.dptr, 
	      key_data.dptr);
      sendString(buf);
      numUsers++;
    }

    return_data = gdbm_nextkey(pwFile, key_data);
    free(key_data.dptr);
  }
    
  if(numUsers > 0) {
    sendString("</table>\n");
  }

  sendString("<p><H4></center>[<A HREF=addUser.html>Add User</A>]&nbsp;"
	     "[<A HREF=showURLs.html>Show URLs</A>]</H4>\n");

#ifdef MULTITHREADED
    releaseMutex(&gdbmMutex);
#endif 
}

void addUser(char* user) {
  sendString("<html>\n");
  sendString("<title>Welcome to ntop!</title>\n");
  sendString("</head><BODY BGCOLOR=#FFFFFF><FONT FACE=Helvetica>\n");
  sendString("<H1><CENTER>Manage ntop User</CENTER></H1><p><hr><p>\n");
  sendString("<FORM METHOD=POST ACTION=/doAddUser>\n");
  if(user != NULL) {
    char tmpStr[128];
    
    sprintf(tmpStr, "User: <INPUT TYPE=HIDDEN NAME=user SIZE=20 VALUE=\"%s\">"
	    "&nbsp;<b>%s</b>&nbsp;\n", &user[1], &user[1]);
    sendString(tmpStr);
  } else
    sendString("User: <INPUT TYPE=text NAME=user SIZE=20>&nbsp;\n");

  sendString("<br>Password: <INPUT TYPE=password NAME=pw SIZE=20><p>\n");
  if(user != NULL)
    sendString("<input type=submit value=\"Modify User\"><input type=reset></form>\n");
  else
    sendString("<input type=submit value=\"Add User\"><input type=reset></form>\n");
  
  sendString("<p><H4>[<A HREF=showUsers.html>Show Users</A>]&nbsp;"
	     "[<A HREF=showURLs.html>Show URLs</A>]</H4>\n");
}

void deleteUser(char* user) {
  datum key_data;

  if(user == NULL) {
    sendString("HTTP/1.0 301 Redirect\n");
    sendString("MIME-version: 1.0\n");
    sendString("Content-type: text/html\n");
    sendString("Location: /showUsers.html\n\n");
	return;
  }

  key_data.dptr = user;
  key_data.dsize = strlen(user)+1;
    
#ifdef MULTITHREADED
  accessMutex(&gdbmMutex);
#endif 

  if(gdbm_delete (pwFile, key_data) != 0) {
    sendHTTPProtoHeader(); sendString("Content-type: text/html\n\n");
    sendString("<html>\n");
    sendString("<title>Welcome to ntop!</title>\n");
    sendString("</head><BODY BGCOLOR=#FFFFFF><FONT FACE=Helvetica>\n");
    sendString("<H1><CENTER>ntop user delete</CENTER></H1><p><p><hr>\n");
    sendString("FATAL ERROR: unable to delete specified user.");
    sendString("<hr><p><H4>[<A HREF=addUser.html>Add User</A>]"
	       "&nbsp;[<A HREF=showURLs.html>Show URLs</A>]</H4>\n");
  } else {
    sendString("HTTP/1.0 301 Redirect\n");
    sendString("MIME-version: 1.0\n");
    sendString("Content-type: text/html\n");
    sendString("Location: /showUsers.html\n\n");
  }

#ifdef MULTITHREADED
  releaseMutex(&gdbmMutex);
#endif 
}

void doAddUser(int _len) {
  char postData[256], tmpBuf[64], *user=NULL, *pw=NULL, *err=NULL;
  int i, rc, len = _len, idx=0;
  datum data_data, key_data;

  if(_len <= 0) {
    err = "ERROR: both user and password must be non empty fields.";
  } else {

    while(len > 0)
      {
	rc = recv(newSock, &postData[idx], len, 0);
	if(rc < 0) {
	  return;
	}

	idx += rc;
	len -= rc;
      }

    postData[idx] = '\0';

  /* printf("Data: '%s' (%d)\n", postData, idx); */

    for(i=0; i<idx; i++) {
      if(postData[i] == '=') {
	if(user == NULL)
	  user = &postData[i+1];
	else
	  pw = &postData[i+1];      
      } else if(postData[i] == '&')
	postData[i] = '\0';
    }

    /* printf("User='%s' - Pw='%s'\n", user, pw); */
    if((user[0] == '\0') || (pw[0] == '\0'))
      err = "ERROR: both user and password must be non empty fields.";
    else {
      sprintf(tmpBuf, "1%s", user);
      key_data.dptr = tmpBuf;
      key_data.dsize = strlen(tmpBuf)+1;
#ifdef WIN32
      data_data.dptr = pw;
#else
      data_data.dptr = (char*)crypt(pw, (const char*)CRYPT_SALT);
#endif
      data_data.dsize = strlen(data_data.dptr)+1;
    
      printf("User='%s' - Pw='%s [%s]'\n", user, pw, data_data.dptr);

#ifdef MULTITHREADED
      accessMutex(&gdbmMutex);
#endif 
      if(gdbm_store(pwFile, key_data, data_data, GDBM_REPLACE) != 0)
	err = "FATAL ERROR: unable to add the new user.";
#ifdef MULTITHREADED
      releaseMutex(&gdbmMutex);
#endif 
    }
  }

  if(err != NULL) {
    sendHTTPProtoHeader(); sendString("Content-type: text/html\n\n");
    sendString("<html>\n");
    sendString("<title>Welcome to ntop!</title>\n");
    sendString("</head><BODY BGCOLOR=#FFFFFF><FONT FACE=Helvetica>\n");
    sendString("<H1><CENTER>ntop user add</CENTER></H1><p><p><hr>\n");
    sendString(err);
    sendString("<hr><p><H4>[<A HREF=addUser.html>Add User</A>]&nbsp;"
	       "[<A HREF=showURLs.html>Show URLs</A>]</H4>\n");
  } else {
    sendString("HTTP/1.0 301 Redirect\n");
    sendString("MIME-version: 1.0\n");
    sendString("Content-type: text/html\n");
    sendString("Location: /showUsers.html\n\n");
  }
}

/* ***********************************
   *********************************** */

void showURLs() {
  u_int numUsers=0;
  char buf[BUF_SIZE];
  datum key_data, return_data;

  sendString("<html>\n");
  sendString("<title>Welcome to ntop!</title>\n");
  sendString("</head><BODY BGCOLOR=#FFFFFF><FONT FACE=Helvetica>\n");
  sendString("<H1><CENTER>Restricted ntop URLs</CENTER></H1><p><hr><p>\n");

#ifdef MULTITHREADED
    accessMutex(&gdbmMutex);
#endif 
  return_data = gdbm_firstkey (pwFile);

  while (return_data.dptr != NULL) {
    /* printf("1) -> %s\n", return_data.dptr); */
    key_data = return_data;

    if(key_data.dptr[0] == '2') { /* 2 = URL */
      if(numUsers == 0) {
	sendString("<center><TABLE BORDER>\n");
	sendString("<TR><TH>URLs</TH><TH>Actions</TH></TR>\n");
      }
	
      sprintf(buf, "<TR><TH ALIGN=LEFT><IMG SRC=/user.gif>"
	      "&nbsp;%s</TH><TD><A HREF=/modifyURL?%s>"
	      "<IMG SRC=/modifyUser.gif BORDER=0 align=absmiddle></A>"
	      "&nbsp;<A HREF=/deleteURL?%s><IMG SRC=/deleteUser.gif BORDER=0 align=absmiddle>"
	      "</A></TD></TR></TH></TR>\n", &key_data.dptr[1], key_data.dptr, 
	      key_data.dptr);
      sendString(buf);
      numUsers++;      
    }

    return_data = gdbm_nextkey(pwFile, key_data);
    free(key_data.dptr);
  }
    
  if(numUsers > 0) {
    sendString("</table>\n");
  }

  sendString("<p><H4></center>[<A HREF=addURL.html>Add URL</A>]"
	     "&nbsp;[<A HREF=showUsers.html>Show Users</A>]</H4>\n");

#ifdef MULTITHREADED
    releaseMutex(&gdbmMutex);
#endif 
}

void addURL(char* url) {
  datum key_data, return_data;
  char authorisedUsers[BUF_SIZE];

  sendString("<html>\n");
  sendString("<title>Welcome to ntop!</title>\n");
  sendString("</head><BODY BGCOLOR=#FFFFFF><FONT FACE=Helvetica>\n");
  sendString("<H1><CENTER>Manage ntop URLs</CENTER></H1><p><hr><p>\n");
  sendString("<FORM METHOD=POST ACTION=/doAddURL>\n");

  if(url != NULL) {
    char tmpStr[128];
    
    sprintf(tmpStr, "URL: http://&lt;ntop host&gt;:&lt;ntop port&gt;/"
	    "<INPUT TYPE=HIDDEN NAME=url SIZE=20 VALUE=\"%s\">"
	    "&nbsp;<b>%s</b>&nbsp;<b>*</b> [Initial URL string]\n", &url[1], &url[1]);
    sendString(tmpStr);

    key_data.dptr = url;
    key_data.dsize = strlen(url)+1;
    return_data = gdbm_fetch(pwFile, key_data);

    if(return_data.dptr != NULL)
      strcpy(authorisedUsers, return_data.dptr);
    else
      authorisedUsers[0] = '\0';
  } else
    sendString("URL: http://&lt;ntop host&gt;:&lt;ntop port&gt;/"
	       "<INPUT TYPE=text NAME=url SIZE=20>&nbsp;* [Initial URL string]\n");

#ifdef MULTITHREADED
  accessMutex(&gdbmMutex);
#endif 
  
  sendString("<br>Authorised Users: <SELECT NAME=users MULTIPLE>\n");

  return_data = gdbm_firstkey (pwFile);

  while (return_data.dptr != NULL) {
    key_data = return_data;

    if(key_data.dptr[0] == '1') { /* 1 = user */
      char tmpStr[128], *selected;

      sprintf(tmpStr, "users=%s", key_data.dptr);

      if(strstr(authorisedUsers, tmpStr) != NULL)
	selected = "SELECTED";
      else
	selected = "";

      sprintf(tmpStr, "<OPTION VALUE=%s %s>%s", 
	      key_data.dptr, selected, &key_data.dptr[1]);
      sendString(tmpStr);
    }

    return_data = gdbm_nextkey(pwFile, key_data);
    free(key_data.dptr);
  }

#ifdef MULTITHREADED
  releaseMutex(&gdbmMutex);
#endif 

  sendString("</SELECT><p>\n");

  if(url != NULL)
    sendString("<input type=submit value=\"Modify URL\"><input type=reset></form>\n");
  else
    sendString("<input type=submit value=\"Add URL\"><input type=reset></form>\n");
  
  sendString("<p><H4>[<A HREF=showUsers.html>Show Users</A>]&nbsp;"
	     "[<A HREF=showURLs.html>Show URLs</A>]</H4>\n");
}


void deleteURL(char* user) {
  datum key_data;

  key_data.dptr = user;
  key_data.dsize = strlen(user)+1;
    
#ifdef MULTITHREADED
  accessMutex(&gdbmMutex);
#endif 

  if(gdbm_delete (pwFile, key_data) != 0) {
    sendHTTPProtoHeader(); sendString("Content-type: text/html\n\n");
    sendString("<html>\n");
    sendString("<title>Welcome to ntop!</title>\n");
    sendString("</head><BODY BGCOLOR=#FFFFFF><FONT FACE=Helvetica>\n");
    sendString("<H1><CENTER>ntop URL delete</CENTER></H1><p><p><hr>\n");
    sendString("FATAL ERROR: unable to delete specified URL.");
    sendString("<hr><p><H4>[<A HREF=addURL.html>Add URL</A>]"
	       "&nbsp;[<A HREF=showUsers.html>Show Users</A>]</H4>\n");
  } else {
    sendString("HTTP/1.0 301 Redirect\n");
    sendString("MIME-version: 1.0\n");
    sendString("Content-type: text/html\n");
    sendString("Location: /showURLs.html\n\n");
  }

#ifdef MULTITHREADED
  releaseMutex(&gdbmMutex);
#endif 
}

void doAddURL(int _len) {
  char postData[256], tmpBuf[64], *err=NULL;
  int rc, len = _len, idx=0;
  datum data_data, key_data;

  if(_len <= 0) {
    err = "ERROR: both url and users must be non empty fields.";
  } else {
    char *url, *users;

    while(len > 0)
      {
	rc = recv(newSock, &postData[idx], len, 0);
	if(rc < 0) {
	  return;
	}

	idx += rc;
	len -= rc;
      }

    postData[idx] = '\0';

    /* printf("Data: '%s' (%d)\n", postData, idx); */

    url = strtok(postData, "&");
    url = &url[4 /* strlen("url=") */];

    users = &url[strlen(url)+1];
    
    /* printf("URL: '%s' - users: '%s'\n", url, users); */

    if((url[0] == '\0') || (users[0] == '\0'))
      err = "ERROR: both url and users must be non empty fields.";
    else {
      sprintf(tmpBuf, "2%s", url);
      key_data.dptr = tmpBuf;
      key_data.dsize = strlen(tmpBuf)+1;
      data_data.dptr = users;
      data_data.dsize = strlen(users)+1;
    
#ifdef MULTITHREADED
      accessMutex(&gdbmMutex);
#endif 
      if(gdbm_store(pwFile, key_data, data_data, GDBM_REPLACE) != 0)
	err = "FATAL ERROR: unable to add the new URL.";
#ifdef MULTITHREADED
      releaseMutex(&gdbmMutex);
#endif 
    }
  }

  if(err != NULL) {
    sendHTTPProtoHeader(); sendString("Content-type: text/html\n\n");
    sendString("<html>\n");
    sendString("<title>Welcome to ntop!</title>\n");
    sendString("</head><BODY BGCOLOR=#FFFFFF><FONT FACE=Helvetica>\n");
    sendString("<H1><CENTER>ntop URL add</CENTER></H1><p><p><hr>\n");
    sendString(err);
    sendString("<hr><p><H4>[<A HREF=addURL.html>Add URL</A>]"
	       "&nbsp;[<A HREF=showUsers.html>Show Users</A>]</H4>\n");
  } else {
    sendString("HTTP/1.0 301 Redirect\n");
    sendString("MIME-version: 1.0\n");
    sendString("Content-type: text/html\n");
    sendString("Location: /showURLs.html\n\n");
  }
}

void addKeyIfMissing(char* key, char* value, int encryptValue) {
  datum key_data, return_data, data_data;

  /* Check existence of user 'admin' */
  key_data.dptr = key;
  key_data.dsize = strlen(key_data.dptr)+1;
  return_data = gdbm_fetch(pwFile, key_data);

  if(return_data.dptr == NULL) {
    /* If not existing, the add user 'admin', pw 'admin' */
	  if(encryptValue) {
#ifdef WIN32
	  data_data.dptr = value;
#else
      data_data.dptr = (char*)crypt(value, (const char*)CRYPT_SALT);
#endif
	  } else
      data_data.dptr = value;    

#ifdef DEBUG
    printf("'%s' <-> '%s'\n", key, data_data.dptr);
#endif

    data_data.dsize = strlen(data_data.dptr)+1;
    gdbm_store(pwFile, key_data, data_data, GDBM_REPLACE);
  }
}

void addDefaultAdminUser() {
  /* Add user 'admin/admin' if not existing */
  addKeyIfMissing("1admin", "admin", 1);

  /* Add user 'admin' for URL 'show...' if not existing */
  addKeyIfMissing("2showU",   "users=1admin", 0);
  addKeyIfMissing("2modifyU", "users=1admin", 0);
  addKeyIfMissing("2deleteU", "users=1admin", 0);
}


#endif /* HAVE_GDBM_H */
