/*
 * freeze.h  -  include file for compression routines
 *
 * Copyright (C) 1997,1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************
 *
 * Parts of this file have been taken from source code published by
 * leo@s514.ipmce.su without any copyright information.
 */


/*
 * Definitions used for setting the Huffmann tables
 */
typedef unsigned long hash_t;				/* hash table type */

#define BUFSIZE		8192				/* buffer size */
#define PRESENSE	256				/* pre-sense buffer size */
#define ENDOF		256
#define THRESHOLD	2

#define _NIL		BUFSIZE
#define _NCHAR		(ENDOF - THRESHOLD + PRESENSE + 1)	/* code : 0 .. _NCHAR-1 */
#define TABSIZE		(_NCHAR * 2 - 1)		/* size of table */
#define ROOTPOS		(TABSIZE - 1)			/* root position */



/*
 * Definitions used for setting the LZSS tables
 */
#ifndef BITS
#define BITS    18
#endif

#if BITS < 15
#undef BITS
#define BITS	15
#endif

#if BITS > 18
#undef BITS
#define BITS	18
#endif

#define LEN0    (BITS/3 + (BITS%3 != 0))
#define LEN1    (BITS/3 + (BITS%3 == 2))
#define LEN2    (BITS/3)

#define MASK0   ((1 << LEN0) - 1)
#define MASK1   ((1 << LEN1) - 1)
#define MASK2   ((1 << LEN2) - 1)

#define array_size      (BUFSIZE + 1 + (1 << BITS))

#ifndef __XENIX__
# define nextof(i)       next[i]
#else
# define parts (array_size/32768 + 1)
# define nextof(i)       next[(i) >> 15][(i) & 0x7fff]
#endif



/*
 * To eliminate function-call overhead
 */
#define DeleteNode(n) \
{\
       nextof(prev[(n)]) = _NIL;\
       prev[(n)] = _NIL;\
}


#define InsertNode(r)\
{\
	register hash_t p; register unsigned short first_son;\
	register unsigned char  *key;\
	key = &text_buf[(r)];\
	p = BUFSIZE + 1 + ((key[0] & MASK0) |\
		     ((key[1] & MASK1) << LEN0) |\
		     ((key[2] & MASK2) << (LEN0 + LEN1)));\
	first_son = nextof(p);\
	nextof((r)) = first_son;\
	nextof(p) = (r);\
	prev[(r)] = p;\
	prev[first_son] = (r);\
}


#define Next_Char()\
if ((c = charin()) != EOF) {\
	text_buf[s] = c;\
	if (s < PRESENSE - 1)\
		text_buf[s + BUFSIZE] = c;\
	s = (s + 1) & (BUFSIZE - 1);\
	r = (r + 1) & (BUFSIZE - 1);\
	InsertNode(r);\
} else {\
	s = (s + 1) & (BUFSIZE - 1);\
	r = (r + 1) & (BUFSIZE - 1);\
	if (--len) InsertNode(r);\
}

