!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  memory.inc
!* Purpose: Definitions for boot rom memory layout
!* Entries: None
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! These values have to be the same as those in the corresponding C header
! file! For an explanation of the memory layout see the C header file.
!
DOSSTART	equ	$0060		! start of DOS data segment
LOWMEM		equ	$1000		! beginning of OS loading area
EXECMEM		equ	$1000		! beginning of exec script load area
FLOPMEM		equ	$2000		! beginning of floppy loading area
FLOPEND		equ	$3000		! end of floppy loading area
HIGHMEM		equ	$9800		! end of OS loading area
MEMEND		equ	$A000		! end of ram on typical PC system
ROMSIZE		equ	$8000		! size of rom area in bytes

DATAOFS		equ	$0008		! offset to special data values


!
!**************************************************************************
!
! Size of interrupt vector area:
!
VECTNUM		equ	256		! number of interrupt vectors
VECTSIZE	equ	VECTNUM * 4	! size of vector area

BOOTROM		equ	$18		! ROM entry interrupt vector
BOOTSTRAP	equ	$19		! Bootstrap interrupt vector
SERVICES	equ	$78		! Bootrom cleanup vector
OLDBOOTROM	equ	$86		! old ROM entry vector

