/*
 * Copyright (c) 1990,1993 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#ifndef GLOBALS_H
#define GLOBALS_H 1

#include <sys/param.h>
#include <sys/cdefs.h>
#include <netdb.h>  /* this isn't header-protected under ultrix */
#include <atalk/afp.h>

/* test for inline */
#ifndef __inline__
#define __inline__
#endif

/* another ultrix bleah */
#ifdef ultrix
extern char *strdup __P((const char *));
#endif

#define MACFILELEN 31

/* a couple of these options could get stuck in unions to save
 * space. */
struct afp_options {
  int connections, port, authbits, transports, tickleval;
  unsigned char debug, uservolfirst, nouservol, passwdbits;
  char hostname[MAXHOSTNAMELEN + 1], *server, *address, *configfile;
  char *uampath, *nlspath;
  char *pidfile, *defaultvol, *systemvol;
  char *guest, *loginmesg, *keyfile, *passwdfile;
};

#define AFPOBJ_TMPSIZ (MAXPATHLEN)
typedef struct AFPObj {
  int proto;
  void *handle, *config;
  struct afp_options options;
  char *Obj, *Type, *Zone;
  void (*exit)(int);
  int (*reply)(void *, int);
  int (*attention)(void *, AFPUserBytes);
  /* to prevent confusion, only use these in afp_* calls */
  char oldtmp[AFPOBJ_TMPSIZ + 1], newtmp[AFPOBJ_TMPSIZ + 1];
} AFPObj;

extern int		afp_version;
extern unsigned char	nologin;
extern char		*username;
extern struct vol	*volumes;
extern struct dir	*curdir;
extern char		getwdbuf[];

extern void afp_options_init __P((struct afp_options *));
extern int afp_options_parse __P((int, char **, struct afp_options *));
extern int afp_options_parseline __P((char *, struct afp_options *));
extern void afp_options_free __P((struct afp_options *, 
				  const struct afp_options *));
extern void setmessage __P((const char *));

#endif /* globals.h */
