/* $Header: /usr/src/redhat/BUILD/Linux-PAM-0.59/modules/pam_ncp/RCS/pam_ncp_auth.c,v 1.3 1998/03/04 02:52:07 dwmw2 Exp $ */

/*
 * Copyright David Woodhouse, 1998.  All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* 
 * $Log: pam_ncp_auth.c,v $
 * Revision 1.3  1998/03/04 02:52:07  dwmw2
 * Oops - licensing has to be GPL as it's using the ncpfs libraries and headers.
 *
 * Revision 1.2  1998/03/04 02:39:12  dwmw2
 * Tidied up (a bit) for initial release.
 *
 * Revision 1.1  1998/03/04 02:21:07  dwmw2
 * Initial revision
 *
 *
 */

#define _GNU_SOURCE
#define _BSD_SOURCE
#define inline __inline__
#include <ncp/nwcalls.h>

#include <features.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>


#ifndef LINUX 

#include <security/pam_appl.h>

#endif  /* LINUX */

#define _PAM_EXTERN_FUNCTIONS
#include <security/pam_modules.h>

static const char rcsid[] = "$Id: pam_ncp_auth.c,v 1.3 1998/03/04 02:52:07 dwmw2 Exp $ pam_ncp authentication functions. Dave@imladris.demon.co.uk";

/* Define function prototypes */

extern 	int _set_auth_tok(	pam_handle_t *pamh, 
				int flags, int argc, 
				const char **argv	);

static int nw_attempt_auth(     const char *server,
                                const char *user,
                                const char *pwd,
				int qflag );


/* The code - what there is of it :) */

PAM_EXTERN
int pam_sm_authenticate(	pam_handle_t *pamh, 
				int flags,
				int argc,
				const char **argv	) 
{
        int retval;
	const char *name;
	char *p;
        int c;
        const char *server;

#define QF_VERBOSE	0x0001
#define QF_DEBUG	0x0002
#define QF_NOSU		0x0004
#define QF_NOSUEQ	0x0008	/* not yet supported */
	int qflag = QF_VERBOSE;
	
	/* Get options */
	for (c = 0; c < argc; c++) {
		if (argv[c][0] == '-') {
			int i;
			
			for (i = 1; argv[c][i]; i++) {
				switch (argv[c][i]) {
					case 'v':qflag |= QF_VERBOSE; break;	/* verbose */
					case 'q':qflag &= ~QF_VERBOSE; break;	/* quiet */
					case 'd':qflag |= QF_DEBUG; break;	/* debug */
					case 's':qflag |= QF_NOSU; break;	/* no supervisor */
					case 'S':qflag |= QF_NOSUEQ; break;	/* no supervisor equivalent */
					default:; /* just silently ignore unknown option... */
				}
			}
		}
	}
	
        /* Get username */
	if ( (retval = pam_get_user( pamh, &name, "login: ") ) != PAM_SUCCESS )
		return retval;

        /* Get password */
	pam_get_item( pamh, PAM_AUTHTOK, (void*) &p );

	if ( !p ) 
		{
			retval = _set_auth_tok( pamh, flags, argc, argv );
			if ( retval != PAM_SUCCESS ) 
				return retval;
 		}
	
	pam_get_item( pamh, PAM_AUTHTOK, (void*) &p );

        /* Find the server name in the configuration. */

        for (c = 0; c < argc; c++) {
                if (!strncmp("server=", argv[c], 7)) {
			int rc;
			
                        server = argv[c] + 7;
			rc = nw_attempt_auth(server, name, p, qflag);
			if (rc == PAM_SUCCESS)
				return PAM_SUCCESS;
                }
        }

	return PAM_AUTH_ERR;
}

/* 
 * Does nothing.
 */

PAM_EXTERN
int pam_sm_setcred( pam_handle_t *pamh, 
		    int flags,
		    int argc, 
		    const char **argv)
{
	return PAM_IGNORE;
}

static int nw_attempt_auth(     const char *server,
                                const char *user,
                                const char *pwd,
				int qflag )
{
        struct ncp_conn_spec spec;
        struct ncp_conn *conn;
	long err;

	if (qflag & QF_DEBUG)
		fprintf(stderr, "Trying to contact %s/%s\n", server, user);
		
        /* Copy the password into place and convert it to upper case */

	strncpy(spec.server, server, sizeof(spec.server)-1);
	spec.server[sizeof(spec.server)-1] = 0;
	str_upper(spec.server);
	strncpy(spec.user, user, sizeof(spec.user)-1);
	spec.user[sizeof(spec.user)-1] = 0;
	strncpy(spec.password, pwd, sizeof(spec.password)-1);
	spec.password[sizeof(spec.password)-1] = 0;
        str_upper(spec.password);
	spec.uid = ~0;
	spec.login_type = NCP_BINDERY_USER;
        
        /* Attempt to log in. */

        if ((conn = ncp_open(&spec, &err)) == NULL)
	{
		if (qflag & (QF_DEBUG | QF_VERBOSE))
			com_err("pam_ncp_auth", err, "when trying to open connection");
		return PAM_AUTH_ERR;
	}
        if (qflag & QF_DEBUG)
		fprintf(stderr, "User %s/%s was successfully authorized\n", server, user);
	err = PAM_AUTH_ERR;
	if (qflag & QF_NOSU) {
		NWObjectID oid;
		NWCCODE err;
		
		err = NWCCGetConnInfo(conn, NWCC_INFO_USER_ID, sizeof(oid), &oid);
		if (err) {
			if (qflag & (QF_DEBUG | QF_VERBOSE))
				com_err("pam_ncp_auth", err, "when retrieving object ID");
			goto bailout;
		}
		if (oid == 0x00000001) {
			if (qflag & (QF_DEBUG | QF_VERBOSE))
				fprintf(stderr, "Access denied for %s/%s because of it is supervisor\n", server, user);
			goto bailout;
		}
		if (qflag & QF_DEBUG)
			fprintf(stderr, "User %s/%s passed supervisor check\n", server, user);
	}
	
	err = PAM_SUCCESS;
	
bailout:;
        /* Close the connection. */
        ncp_close(conn);
        return err;
}



/* static module data */
#ifdef PAM_STATIC
struct pam_module _pam_ncp_auth_modstruct = {
    "pam_ncp_auth",
    pam_sm_authenticate,
    pam_sm_setcred,
    NULL,
    NULL,
    NULL,
    NULL,
};
#endif




