#!/bin/perl
#
#  madoka-chan  ver 4.1
#
#      Copyright(c)1998- cookie (cookie@madoka.org)
#                        The madoka project
#      This is free software.

require 5.003;
$mdk_label = 'madoka';
$mdk_version = '4.1.15R';

&init;
exit;

sub mainloop {
  local($nfound, $rout, $wout, $eout, $errno, $reason, $cl, $cl_no);
  for (;;) {
    $nfound = select($rout=$rin, $wout=$win, $eout=$ein, $interval);
    foreach (split(/$;/, $per_sec)) {
      next unless $_;
      &$_ if defined(&$_);
    }
    if ($nfound < 0) {
      if ($! == 4) {
        $nfound = 0;
      } else {
        $errno = sprintf("%d", $!);
        &down("[ERROR] $errno ($!) in select.\n");
      }
    }
    &current_time;
    if ($cmin != $min) {
      if ($chour != $hour) {
        if ($cday != $mday) {
          foreach (split(/$;/, $per_day)) {
            next unless $_;
            &$_ if defined(&$_);
          }
          $cday = $mday;
        }
        foreach (split(/$;/, $per_hour)) {
          next unless $_;
          &$_ if defined(&$_);
        }
        $chour = $hour;
      }
      foreach (split(/$;/, $per_min)) {
        next unless $_;
        &$_ if defined(&$_);
      }
      $cmin = $min;
    }
    if (vec($sv_state, 0, 1)) {
      if (time - $sv_tm > $sv_tmout) {
        $sv_tm = time;
        &close_server($sv_no, 'dead conection');
      }
    } else {
      if (time - $sv_tm_cn > $sv_tmout_cn) {
        $sv_tm_cn = $sv_tm = time;
        &connect_server;
      }
    }
    next unless $nfound;
    &init_client if vec($rout, $ln_no, 1);
    for ($cl_no = 0; $cl_no <= $cl_max; $cl_no++) {
      next unless (vec($rout, $cl_no, 1) && vec($cl_cn, $cl_no, 1));
      $cl = $cl[$cl_no];
      unless (sysread($cl, $mes, 4096)) {
        $reason = $! ? "$!" : "closed";
        &close_client($cl_no, $reason);
      } else {
        $mes =~ tr/\015/\012/;
        $cl_buf[$cl_no] .= $mes;
        while ((@cl_bufl = split(/\r*\n/, $cl_buf[$cl_no], 2)) == 2) {
          $cl_buf[$cl_no] = $cl_bufl[1];
          &client($cl_no, $cl_bufl[0]);
        }
        $cl_buf[$cl_no] = $cl_bufl[0];
      }
    }
    if (vec($rout, $sv_no, 1)) {
      unless (sysread(SERVER, $mes, 4096)) {
        $reason = $! ? "$!" : "closed by server";
        &send('ccn', "NOTICE $us_nick :[CLOSE] $sv[0] ($reason)\n");
        &close_server($sv_no, "$reason");
      } else {
        $sv_buf .= $mes;
        $sv_tm = time;
        while ((@sv_bufl = split(/\r*\n/, $sv_buf, 2)) == 2) {
          $sv_buf = $sv_bufl[1] || '';
          &server($sv_no, $sv_bufl[0]);
        }
        $sv_buf = $sv_bufl[0];
      }
    }
  }
}
sub init {
  eval 'use Config';
  eval 'use Socket';
  if ($@) {
    foreach (@INC) {
      require 'sys/socket.ph' if -r "$_/sys/socket.ph";
      require 'netinet/in.ph' if -r "$_/netinet/in.ph";
    }
  }
  unshift(@INC, "$1/plugin") if $0 =~ /^(.*)\/[^\/]+$/;
  $MDK = $0;
  @ARG = @ARGV;
  $SOCKADDR = 'S n a4 x8';
  $AF_INET = eval { &AF_INET } || 2;
  $PF_INET = eval { &PF_INET } || $AF_INET;
  $SOCK_STREAM = eval { &SOCK_STREAM } || 1;
  $SOL_SOCKET = eval { &SOL_SOCKET };
  $SO_REUSEADDR = eval { &SO_REUSEADDR };
  $SO_KEEPALIVE = eval { &SO_KEEPALIVE };
  $INADDR_ANY = eval { &INADDR_ANY } || pack('C4', 0, 0, 0, 0);
  $PROT = getprotobyname('tcp') || 6;

  $ENV{'LANG'} = 'C';
  $ENV{'LC_TIME'} = 'C';

  &init_madoka;
  if ($nofork == 0) {
    exit if eval { fork };
    $nofork = 1 if $@;
  }
  &read_rc;
  open(STDIN, "/dev/null");
  &mes("[!] Start: $mdk_label $mdk_version\n");
  $0 = "$mdk_label($us_nick/$mdk_version)";
  &mainloop;
}
sub init_madoka {
  $perl_version = sprintf("%1.5f", $]);
  srand(time+$$);
  $interval = 1;
  $sv_tmout_cn = 90;
  $sv_tmout = 900;
  $sv_tm = time;
  $sv_no = 0;
  $cl_max = 256;
  $homedir = $ENV{'HOME'};
  $rin = $win = $ein = '';
  $nofork = 0;
  $chl_header = '\#\&\+\!\%';
  while ($_ = shift(@ARGV)) {
    if ($_ eq '-rc') {
      $mdk_rc = shift(@ARGV);
      $mdk_rc =~ s/^~\//$homedir\//;
      &down("[ERROR] Cannot find: $mdk_rc\n") unless -f $mdk_rc;
    } elsif ($_ eq '-modes') {
      $mdk_modes = shift(@ARGV);
      $mdk_modes =~ s/^~\//$homedir\//;
      &down("[ERROR] Cannot find: $mdk_modes\n") unless -f $mdk_modes;
    } elsif ($_ eq '-nofork') {
      $nofork = 1;
    }
  }
}
sub read_rc {
  $mdk_rc = &search_file('madoka.rc') unless $mdk_rc;
  return unless &_redo($mdk_rc, 1);
  &list_init($per_min) unless $per_min;
  &list_add($per_min, 'read_rc');
  local(@rclines, $file);
  if (open(RC, $mdk_rc)) {
    @rclines = <RC>;
    close(RC);
  } else {
    &down("[ERROR] cannot open: $mdk_rc\n");
  }
  foreach (@rclines) {
    s/\n$//;
    next if /^\s*$/ || /^\#/;
    if (/^\[([^\]]+)\]$/) {
      $rc_section = $1;
      next;
    } elsif (/^[^=]+=.*/) {
      $rc_line = $_;
    }
    $file = &search_file("rc/$rc_section.mpi");
    do $file;
  }
  $file = &search_file("rc/default.mpi");
  do $file;
}
sub init_client {
  $cl_seq++;
  local($cl) = 'C' . $cl_seq;
  $ac = accept($cl, LISTEN);
  select($cl); $| = 1; select(L0);
  local($cl_no) = fileno($cl);
  $cl_max = $cl_no if $cl_no > $cl_max;
  $cl[$cl_no] = $cl;
  $cl_seq[$cl_no] = $cl_seq;
  undef $cl_pass[$cl_no];
  vec($rin, $cl_no, 1) = 1;
  vec($cl_cn, $cl_no, 1) = 1;
  vec($cl_ok, $cl_no, 1) = 0;
  foreach (split(/$;/, $chl)) {
    next unless $_;
    vec($cl_chan{$_}, $cl_no, 1) = 0;
  }
  local($l, @h, $p, $addr);
  local($ac) = getpeername($cl);
  ($l, $port[$cl_no], @h) = unpack('S n C4', $ac);
  ($l, $p, $addr, $l) = unpack($SOCKADDR, $ac);
  $cl_ip[$cl_no] = unpack('N', $addr);
  $host[$cl_no] = join('.', @h);
  if ($#cl_hosts >= 0) {
    &close_client($cl_no,
		  "[!] Denied: $host[$cl_no]($port[$cl_no]/$cl_seq[$cl_no])")
	unless &check_host($cl_no);
  }
  &mes("[!] Connect: $host[$cl_no]($port[$cl_no])/$cl_seq[$cl_no]\n");
}
sub connect_server {
  local($sv_port) = $sv_port[0];
  local($that, $l);
  if ($sv_port =~ /,/) {
    local(@l) = split(/,/, $sv_port[0]);
    $sv_port = $l[int(rand($#l+1))];
  }
  &send('ccn', "NOTICE $us_nick :[!] try: connect to $sv[0]($sv_port)\n");
  $that = &getaddrinfo6($sv[0], $sv_port[0]);
  unless (socket(SERVER, $PF_INET, $SOCK_STREAM, $PROT)) {
    &mes("[ERROR] sv/socket: $!\n");
    return 0;
  }
  $sv_no = fileno(SERVER);
  select(SERVER); $| = 1; select(L0);
  if ($ENV{'OSTYPE'} !~ m/linux/i) {
    $l = pack($SOCKADDR, $AF_INET, 0, $INADDR_ANY);
    unless (bind(SERVER, $l)) {
      &mes("[ERROR] sv/bind: $!\n");
      return 0;
    }
  }
  $sv_tm_cn = time;
  unless (connect(SERVER, $that)) {
    &send('ccn', "NOTICE $us_nick :[!] cannot connect, try again after.\n");
    &send('ccn', "NOTICE $us_nick :[!] if need, type: /server <host> [<port>]\n");
    &mes("[!] cannot connect: $sv[0]($sv_port)\n");
    vec($rin, $sv_no, 1) = 0;
    vec($win, $sv_no, 1) = 0;
    $sv_buf = $sv_state = '';
    $nickuse = 0;
    $nick_try = $us_nick;
    push(@sv, shift(@sv));
    push(@sv_port, shift(@sv_port));
    push(@sv_pass, shift(@sv_pass));
    return 0;
  }
  &mes("[!] server: $sv[0]($sv_port)\n");
  vec($rin, $sv_no, 1) = 1;
  vec($sv_state, 0, 1) = 1;
  &regist_server;
}
sub regist_server {
  $nickuse = 0;
  @ctcp_queue = ();
  $nick_try = $us_nick unless $nick_try;
  &send('sv', "PASS $sv_pass[0]\n") if $sv_pass[0];
  &send('sv', "USER $us_id * * :$us_name\n");
  &send('sv', "NICK $nick_try \n");
}
sub join_server {
  local($joinchannels, $joinchannelskey, $autokeys, $chanr, $chanv);
  foreach (split(/$;/, $chl_autojoin)) {
    next unless $_;
    if (&check_chan($_)) {
      &list_add($chl, $_);
      if ($at_key{$_}) {
	$joinchannelskey .= ",$_";
	$autokeys .= ",$at_key{$_}";
      } else {
	$joinchannels .= ",$_";
      }
    } else {
      &send('cch', ":$sv[0] NOTICE $us_nick :[ERROR] channel name($_)\n");
      &mes("[ERROR] channel name($_)\n", 'L');
    }
  }
  $joinchannels =~ s/^,//;
  $joinchannelskey =~ s/^,//;
  $autokeys =~ s/^,//;
  &send('sv', "JOIN $joinchannels \n") if $joinchannels;
  &send('sv', "JOIN $joinchannelskey $autokeys \n") if $joinchannelskey;
  &send('sv', "AWAY :$mes_away\n") if $mes_away;
  $us_mes_away = $mes_away;
}
sub close_server {
  local($sv_no, $reason) = @_;
  close(SERVER);
  &mes("[!] close server: $sv[0]($reason)/$sv_no\n");
  vec($rin, $sv_no, 1) = 0;
  local($chanr, $chanv);
  foreach (split(/$;/, $chl)) {
    next unless $_;
    &send('ccn', ":$us_nick!$machine{$us_nick} PART :$_\n");
  }
  push(@sv, shift(@sv));
  push(@sv_port, shift(@sv_port));
  push(@sv_pass, shift(@sv_pass));
  &list_init($chl);
  vec($rin, $sv_no, 1) = 0;
  vec($win, $sv_no, 1) = 0;
  $sv_buf = '';
  $sv_state = '';
  $nickuse = 0;
  $nick_try = $us_nick;
}
sub close_client {
  local($cl_no, $reason) = @_;
  &mes("[!] close: $cl_seq[$cl_no] ($reason)\n");
  close($cl[$cl_no]);
  vec($rin, $cl_no, 1) = 0;
  vec($cl_cn, $cl_no, 1) = 0;
  vec($cl_ok, $cl_no, 1) = 0;
  undef $cl_nick[$cl_no];
  undef $cl_user[$cl_no];
  undef $cl_code[$cl_no];
  local($l) = $cl_max;
  for ($i = 0, $no_client = 1; $i <= $l; $i++) {
    next unless vec($cl_cn, $i, 1);
    $cl_max = $i;
    $no_client = 0;
  }
  if ($no_client == 1) {
    if ($us_mes_away ne $mes_away) {
      &mes("[!] Autoaway: $mes_away\n");
      &send('sv', "AWAY :$mes_away\n");
      $us_mes_away = $mes_away;
    }
    vec($at_state, 6, 1) = 1 if $dcc_client && !vec($at_state, 6, 1);
  }
}
sub server {
  local($sv_no, $line) = @_;
  ($from, $where, $command, $pr) =
      ($line =~ /^(:[^! ]*)?(![^ ]*)? *([^ ]+) *:?(.*)$/);
  $from =~ s/^:// if $from;
  $where =~ s/^!// if $where;
  $machine{$from} = $where if $where;
  local($com) = $command;
  $com =~ tr/A-Z/a-z/;
  local($sv_cmd) = "sv_$com";
  $pr =~ s/\s+$//;
  &mes("[Ds] $line /\n", 'D');
  if (defined(&$sv_cmd)) {
    &$sv_cmd($from, $pr);
  } else {
    &send('ccn', "$line\n");
  }
}
sub client {
  local($cl_no, $line) = @_;
  local($u, $command, $pr) = ($line =~ /^(:[^ ]*)? *([^ ]+) *:?(.*)$/);
  return unless $command;
  local($com) = $command;
  $com =~ tr/A-Z/a-z/;
  $pr =~ s/\s+$//;
  &mes("[Dc] $line / seq = $cl_seq[$cl_no]\n", 'D');
  unless (vec($cl_ok, $cl_no, 1)) {
    &check_pass($cl_no) if &no_pass($cl_no, $line);
    return;
  }
  $ctcp_cmd_p = '';
  $cl_code[$cl_no] = $kanji_lock_code || &kanji_code($pr)
      if &list_exist($plugin_list, 'kanji');
  $com = 'send' if $com eq 'csend';
  local($cl_cmd) = "cl_$com";
  &mes("[D] cl_cmd = $cl_cmd\n", 'D');
  if (defined(&$cl_cmd)) {
    &$cl_cmd($pr, $cl_no);
  } else {
    &send('sv', "$line\n");
  }
}
sub no_pass {
  local($cl_no, $line) = @_;
  local($where, $com, $arg) = ($line =~ /^(:[^ ]*)? *([^ ]+) :?(.+)$/);
  &mes("[D] nopasswd = $line\n", 'D');
  if ($com =~ /^pass$/i) {
    $cl_pass[$cl_no] = $arg;
    return 0;
  } elsif ($com =~ /^user$/i) {
    $cl_user[$cl_no] = $arg;
    return 1 if $cl_nick[$cl_no];
    return 0;
  } elsif ($com =~ /^nick$/i) {
    $cl_nick[$cl_no] = $arg;
    return 1 if $cl_user[$cl_no];
    return 0;
  } elsif ($com =~ /^quit$/i) {
    &close_client($cl_no, 'I Quit');
    return 0;
  }
  &send('cl', ":$sv[0] 451 * :You have not registered.\n");
  return 0;
}
sub check_pass {
  local($cl_no) = @_;
  if ($cl_pass[$cl_no] ne $us_pass) {
    &send('cl', ":$sv[0] 464 $cl_nick[$cl_no] :Password Incorrect.\n");
    &send('cl', "ERROR :Closing Link: $cl_nick[$cl_no] (Bad Password)\n");
    &close_client($cl_no, 'wrong password');
    return;
  }
  vec($cl_ok, $cl_no, 1) = 1;
  &mes("[!] password/$cl_seq[$cl_no]\n");
  &send('cl', ":$cl_nick[$cl_no] NICK $us_nick \n")
      if $cl_nick[$cl_no] ne $us_nick;
  &send('cl', ":$sv[0] 001 $us_nick :" .
	"Welcome to the Internet Relay Network $us_nick!$machine{$us_nick}\n");
  &send('cl', ":$sv[0] 002 $us_nick :$sv_mes[2]\n") if $sv_mes[2];
  &send('cl', ":$sv[0] 003 $us_nick :$sv_mes[3]\n") if $sv_mes[3];
  &send('cl', ":$sv[0] 004 $us_nick $sv_mes[4]\n") if $sv_mes[4];
  &send('cl', ":$sv[0] 375 $us_nick :- $sv[0] Message of the Day -\n");
  &send('cl', ":$sv[0] 376 $us_nick :End of /MOTD command.\n");
  if (vec($sv_state, 0, 1)) {
    &taillog;
    local($l, $ll);
    foreach (split(/$;/, $chl)) {
      next unless $_;
      $ll = '';
      &send('cl', ":$us_nick!$machine{$us_nick} JOIN :$_\n");
      &send('cl', ":$sv[0] 332 $us_nick $_ :$topic{$_}\n") if $topic{$_};
      $l = length(":$sv[0] 353 $us_nick = $_ :");
      foreach $name (split(/$;/, $ls_mem{$_})) {
	next unless $name;
	if ($l + length($name) + 1 > 510) {
	  &send('cl', ":$sv[0] 353 $us_nick = $_ :$ll\n");
	  $l = length(":$sv[0] 353 $us_nick = $_ :");
	  $ll = '';
	}
	$l += length($name) + 1;
	$ll .= "$name ";
      }
      &send('cl', ":$sv[0] 353 $us_nick = $_ :$ll\n") if $ll;
      &send('cl', ":$sv[0] 366 $us_nick $_ :End of /NAMES list.\n");
    }
  } else {
    &send('cl', "NOTICE $us_nick :[!] Now, no server connection.\n");
  }
  &send('cl', ":$sv[0] 301 $us_nick $us_nick :$us_mes_away\n")
      if $us_mes_away;
  if ($us_mes_away ne '') {
    &mes("[!] Autoaway off\n", 'ALL');
    $us_mes_away = '';
    &send('sv', "AWAY :\n");
  }
  vec($at_state, 6, 1) = 0 if $dcc_client && vec($at_state, 6, 1);
}
sub getaddrinfo6 {
  local($l, $port) = @_;
  $l = (gethostbyname($l))[4];
  return pack('S n a4 x8', $AF_INET, $port, $l);
}
sub plugin {
  foreach (split(/$;/, $plugin_do)) {
    next unless $_;
    do $_;
  }
}
sub redo {
  local($file) = &search_file($_[0]);
  &down("[ERROR] Not Found: $_[0]\n") unless -f $file;
  local($l) = q! do $file;
    &mes("plugin new: $file\n") if $log_handle{'L'}; !;
  &_redo($file, $l);
}
sub _redo {
  local($file, $l) = @_;
  if ($plugin_change{$file}) {
    $plugin_change_old{$file} = $plugin_change{$file};
  } else {
    $plugin_change_old{$file} = 0;
  }
  $plugin_change{$file} = -M $file;
  if ($plugin_change_old{$file} > $plugin_change{$file} ||
      $plugin_change_old{$file} == 0) {
    eval($l);
    return 1;
  }
  return 0;
}
sub search_file {
  local($file) = @_;
  foreach (@plugindir, './', './plugin/', @INC) {
    $_ .= '/' if $_ !~ /\/$/;
    if (-r "$_$file") {
      $file = "$_$file";
      last;
    }
  }
  return $file;
}
sub ctcp {
  local($chan, $mes) = @_;
  local($com, $mes) = split(/\s/, $mes, 2);
  local($cmd, $ff) = ($com, 0);
  local($ctcp_cmd) = "ctcp_$com";
  $ctcp_cmd =~ tr/A-Z/a-z/;
  ($chanr, $chanv) = &alias_chan($chan);
  &mes("[d] chan(ctcp) = $chanv\n", 'D') if $chanv;
  if ($chanr eq $us_nick) {
    &mes("[!] ctcp from $from: $com $mes\n", 'P') if $com;
  } else {
    &mes("[!] ctcp from $from($chanv): $com $mes\n", 'P') if $com;
  }
  push(@ctcp_queue, "$ctcp_cmd:$from:$mes") if $ctcp_cmd ne 'ctcp_';
  ($ctcp_cmd, $from, $mes) = split(/:/, shift(@ctcp_queue), 3);
  if (defined(&$ctcp_cmd)) {
    &$ctcp_cmd($mes);
    if ($t_count < 1) {
      $ff = 1 if $dcc_client || $com !~ /^dcc$/i;
    } else {
      unshift(@ctcp_queue, "$ctcp_cmd:$from:$mes");
    }
  } else {
    &send('cch', "NOTICE $us_nick :$com\@$from: $mes\n") if $com;
    $ff = 0;
  }
  return $ff;
}
sub mes {
  local($mes, $chan) = @_;
  $mes =~ s/\r*\n$//;
  if ($yr_cache && $chan ne 'D') {
    push(@cache_mes, $mes);
    shift(@cache_mes) if $#cache_mes > $yr_cache;
  }
  &Log("$mes\n", $chan || 'ALL') if &list_exist($plugin_list, 'log');
}
sub send {
  local($com, $mes, $cl_no) = @_;
  local($sn_cmd) = "sn_$com";
  if (defined(&$sn_cmd)) {
    &kanji_jis(*mes) if &list_exist($plugin_list, 'kanji');
    $mes =~ s/\r*\n$/\r\n/;
    &$sn_cmd($mes, $cl_no);
    &mes("[sn/$com] $mes", 'D');
  }
}
sub sn_sv {
  return unless vec($sv_state, 0, 1);
  local($mes) = $_[0];
  if ($mes =~ /^[^\001]*\001[^\001]*\001/) {
    unshift(@mes_buf, $mes);
    $ctcp_cmd_p = '' unless &list_exist($per_sec, 'flood');
  } elsif ($mes) {
    push(@mes_buf, $mes);
  }
  $mes = shift(@mes_buf);
  if (&list_exist($per_sec, 'flood')) {
    &flood_send($mes);
  } else {
    print SERVER $mes;
    local($chan, $pr) = ($mes =~ /^PRIVMSG ([^ ]+) :(.*)/);
    local($chanr, $chanv) = &alias_chan($chan);
    &mes(">$chanv:$us_nick< $pr\n", $chanr) if $pr;
  }
}
sub sn_cl {
  return unless $cl;
  local($mes, $cl_no) = @_;
  local($cl_code, $kanji);
  if (&list_exist($plugin_list, 'kanji') && $cl_code[$i]) {
    $cl_code = $cl_code[$i];
    $kanji = "kanji_$cl_code";
    &$kanji(*mes);
  }
  print $cl $mes;
}
sub sn_ccn {
  local($mes, $cl_no) = @_;
  local($cc, $cl_code, $kanji);
  for ($i = 0; $i <= $cl_max; $i++) {
    $cc = $cl[$i];
    next unless $cc;
    if (vec($cl_ok, $i, 1)) {
      if (&list_exist($plugin_list, 'kanji') && $cl_code[$i]) {
	$cl_code = $cl_code[$i];
	$kanji = "kanji_$cl_code";
	&$kanji(*mes);
      }
      print $cc $mes;
    }
  }
}
sub sn_cch {
  local($mes, $cl_no) = @_;
  local($cc, $cl_code, $kanji);
  for ($i = 0; $i <= $cl_max; $i++) {
    $cc = $cl[$i];
    next unless $cc;
    if (vec($cl_ok, $i, 1) && !vec($cl_chan, $i, 1)) {
      if (&list_exist($plugin_list, 'kanji') && $cl_code[$i]) {
	$cl_code = $cl_code[$i];
	$kanji = "kanji_$cl_code";
	&$kanji(*mes);
      }
      print $cc $mes;
    }
  }
}
sub sn_cco {
  local($mes, $cl_no) = @_;
  local($cc, $cl_code, $kanji);
  for ($i = 0; $i <= $cl_max; $i++) {
    $cc = $cl[$i];
    next unless $cc;
    if (vec($cl_ok, $i, 1) && !vec($cl_chan, $i, 1) && $cl_no != $i) {
      if (&list_exist($plugin_list, 'kanji') && $cl_code[$i]) {
	$cl_code = $cl_code[$i];
	$kanji = "kanji_$cl_code";
	&$kanji(*mes);
      }
      print $cc $mes;
    }
  }
}
sub sendSCL {
  local($mes, $chan, $code) = @_;
  local($chanr, $chanv) = &alias_chan($chan);
  local($cl_code) = $cl_code[$cl_no] || 'jis';
  local($kanji) = "kanji_$cl_code";
  &kanji_jis(*mes, $code) if &list_exist($plugin_list, 'kanji');
  $mes =~ s/\r*\n$//;
  &sn_sv("PRIVMSG $chanr :$mes\r\n");
  &$kanji(*mes) if &list_exist($plugin_list, 'kanji');
  &sn_cch(":$us_nick!$machine{$us_nick} PRIVMSG $chanr :$mes\r\n");
}
sub cached {
  local($mes, $chan, $code) = @_;
  local($chanr, $chanv) = &alias_chan($chan);
  foreach (@cache_mes) {
    return if $_ eq ">$chanv:$us_nick< $mes";
  }
  &sendSCL($mes, $chan, $code);
}
sub list_init {
  $_[0] = "$;";
}
sub list_add {
  &list_init($_[0]) unless $_[0];
  unless (&list_exist(@_)) {
    $_[0] .= "$_[1]$;";
    return 1;
  }
  return 0;
}
sub list_del {
  local($u, @pr) = @_;
  local($f, $l) = (0, '');
  foreach (@pr) {
    $l = $_;
    $l =~ s/(\W)/\\$1/g;
    if ($_[0] =~ /$;$l$;/i) {
      substr($_[0], index($_[0], "$;$_$;"), length("$;$_$;")) = "$;";
      $f = 1;
    }
  }
  return $f;
}
sub list_exist {
  local($u, @pr) = @_;
  local($f, $l) = (0, '');
  foreach (@pr) {
    next unless $_;
    $l = $_;
    $l =~ s/(\W)/\\$1/g;
    if ($_[0] =~ /$;($l)$;/i) {
      substr($_[0], index($_[0], "$;$1$;"), length("$;$1$;")) = "$;";
      $_[0] .= "$_$;";
      $f = 1;
    }
  }
  return $f;
}
sub list_change {
  local($pr) = $_[1];
  $pr =~ s/(\W)/\\$1/g;
  if ($_[0] =~ /$;$pr$;/i) {
    substr($_[0], index($_[0], "$;$_[1]$;"), length("$;$_[1]$;")) = "$;$_[2]$;";
    return 1;
  }
  return 0;
}
sub current_time {
  ($sec, $min, $hour, $mday, $mon, $year) = localtime(time);
  $mon++;
  $year += 1900;
}
sub alias_chan {
  local($chan) = local($chanr) = local($chanv) = $_[0];
  return unless $_[0];
  if ($chl_mask ne '') {
    local($l) = $chl_mask;
    $l =~ s/(\W)/\\$1/g;
    if ($chan =~ /^\#(.*):$l$/i) {
      $chanv = '%' . $1;
    }
    if ($chan =~ /^%/) {
      $chan =~ s/^%/\#/;
      $chan .= ":$chl_mask" if $chl_mask ne '';
      $chanr = $chan;
    }
  }
  return($chanr, $chanv);
}
sub taillog {
  if ($taillog) {
    foreach (@tail) {
      next unless $_;
      &send('cl', "NOTICE $us_nick :$_");
    }
    &send('cl', "NOTICE $us_nick :[!] end of taillog\n");
  }
}
sub check_chan {
  $_[0] =~ s/\033\$\@/\033\$B/g;
  $_[0] =~ s/\033\(J/\033\(B/g;
  return 0 if $_[0] =~ /,/ || $_[0] =~ / / || $_[0] =~ /\007/ ||
      $_[0] =~ /^[^$chl_header]/;
  return 1;
}
sub check_host {
  local($cl_no) = @_;
  local($cl_addr, $netmask, $l);
  if ($host[$cl_no] =~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/) {
    $cl_addr = 2 ** 24 * $1 + 2 ** 16 * $2 + 2 ** 8 * $3 + $4;
  }
  foreach (@cl_hosts) {
    next unless $_;
    if (/^(.+)\/(.+)$/) {
      $l = $1;
      $netmask = $2;
    } else {
      $l = $_;
      $netmask = 32;
    }
    if ($l =~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/) {
      $l = 2 ** 24 * $1 + 2 ** 16 * $2 + 2 ** 8 * $3 + $4;
    } else {
      $l = unpack('N1', (gethostbyname($_))[4]);
    }
    if ($netmask =~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/) {
      $netmask = 2 ** 24 * $1 + 2 ** 16 * $2 + 2 ** 8 * $3 + $4;
    } else {
      $netmask = int((2 ** $netmask - 1) << (32 - $netmask));
    }
    return 1 if ($cl_addr & $netmask) == ($l & $netmask);
  }
  return 0;
}
sub down {
  local($l) = $_[0];
  $l .= "\n" if $l !~ /\n$/;
  print STDERR $l;
  exit 0;
}
__END__
