/*
 * lftp and utils
 *
 * Copyright (c) 1996-1999 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: rmJob.cc,v 1.4 1999/05/26 14:04:10 lav Exp $ */

#include <config.h>

#include <errno.h>
#include "rmJob.h"
#include "plural.h"

rmJob::rmJob(FileAccess *s,ArgV *a) : TreatFileJob(s,a)
{
   mode=FA::REMOVE;
}

void  rmJob::SayFinal()
{
   if(failed==file_count)
      return;
   if(file_count==1)
      printf(_("%s ok, `%s' removed\n"),op,first);
   else if(failed)
   {
      if(mode==FA::REMOVE_DIR)
	 printf(_("%s failed for %d of %d directories\n"),op,failed,file_count);
      else
	 printf(_("%s failed for %d of %d files\n"),op,failed,file_count);
   }
   else
   {
      if(mode==FA::REMOVE_DIR)
	 printf(plural("%s ok, %d director$y|ies$ removed\n",file_count),
	    op,file_count);
      else
	 printf(plural("%s ok, %d file$|s$ removed\n",file_count),
	    op,file_count);
   }
}

void rmJob::TreatCurrent()
{
   session->Open(curr,mode);
}
