#ifndef __SETTINGS_H
#define __SETTINGS_H

enum
{
    SETUP_TYPE_TOGGLEBUTTON,
    SETUP_TYPE_SPIN,
    SETUP_TYPE_ENTRY,
    SETUP_TYPE_INT_OBJECT, /* gtk_object_get_data(widget, "value") */
};

typedef struct
{
    gint type;
    gpointer data;
    gchar *tag;
    gpointer def;
    gpointer widget;
}
SETUP_REC;

/* misc */
enum
{
    OPTION_WWW_CLIENT,
    OPTION_FTP_CLIENT,
    OPTION_MAIL_CLIENT,

    OPTION_CTCP_VERSION_REPLY,
    OPTION_DEFAULT_QUIT_MESSAGE,
    OPTION_DEFAULT_USER_MODE,

    OPTION_MIN_LAG_CHECK_TIME,
    OPTION_MAX_LAG_BEFORE_DISCONNECT,

    OPTION_KNOCKOUT_TIME,

    OPTION_AWAYLOG_FILE,
    OPTION_AWAYLOG_LEVEL,
};

/* history */
enum
{
    OPTION_MAX_TEXTWIDGET_LINES,
    OPTION_BLOCK_REMOVE_LINES,

    OPTION_MAX_COMMAND_HISTORY,
    OPTION_RAWLOG_LINES,

    OPTION_WINDOW_HISTORY,
};

/* nick completion */
enum
{
    OPTION_COMPLETION_CHAR,
    OPTION_COMPLETION_DISABLE_AUTO,
    OPTION_COMPLETION_KEEP_PUBLICS,
    OPTION_COMPLETION_KEEP_OWNPUBLICS,
    OPTION_COMPLETION_KEEP_PRIVATES,
};

/* flood protection */
enum
{
    OPTION_FLOOD_TIMECHECK,
    OPTION_FLOOD_MAX_MSGS,
    OPTION_AUTOIGNORE_TIME,
    OPTION_CTCP_FLOODCHECK,
    OPTION_CTCP_MAX_QUEUE,
    OPTION_CMD_QUEUE_SPEED,
};

/* look and feel */
enum
{
    OPTION_SHOW_MENUBAR,
    OPTION_SHOW_TOOLBAR,
    OPTION_SHOW_STATUSBAR,
    OPTION_SHOW_NICKLIST,
    OPTION_SHOW_TIMESTAMPS,
    OPTION_SHOW_MSGS_TIMESTAMPS,
    OPTION_HIDE_TEXT_STYLES,
    OPTION_BELL_BEEPS,
    OPTION_ACTLIST_MOVES,
    OPTION_PRIVMSG_BEEPS,

    OPTION_USE_STATUS_WINDOW,
    OPTION_USE_MSGS_WINDOW,
    OPTION_AUTORAISE_MSGS_WINDOW,
    OPTION_AUTOCREATE_QUERIES,
    OPTION_NOTIFYLIST_POPUPS,
    OPTION_USE_TABBED_WINDOWS,
    OPTION_TAB_ORIENTATION,
};

/* irc proxy */
enum
{
    OPTION_USE_IRCPROXY,
    OPTION_PROXY_ADDRESS,
    OPTION_PROXY_PORT,
    OPTION_PROXY_STRING,
};

/* dcc */
enum
{
    OPTION_DCC_AUTORENAME,
    OPTION_DCC_AUTOGET,
    OPTION_DCC_AUTOGET_SIZE,
    OPTION_DCC_DOWNLOAD_PATH,
    OPTION_DCC_FILE_CREATE_MODE,
    OPTION_DCC_AUTOGET_MASKS,
    OPTION_DCC_AUTOCHAT_MASKS,

    OPTION_DCC_FAST_SEND,
    OPTION_DCC_UPLOAD_PATH,

    OPTION_DCC_MIRC_CTCP,
    OPTION_DCC_AUTODISPLAY_DIALOG,
    OPTION_DCC_BLOCK_SIZE,
    OPTION_DCC_PORT,
    OPTION_DCC_TIMEOUT,
};

/* appearance */
enum
{
    OPTION_BUGGY_GTKTHEMES,
    OPTION_USE_ITEXT,
    OPTION_BACKGROUND_TRANSPARENT,

    OPTION_PANEL_MAX_CHANNELS,
};

/* server */
enum
{
    OPTION_SERVER_RECONNECT,
    OPTION_SOURCE_HOST,
    OPTION_SKIP_MOTD,

    OPTION_DEFAULT_NICK,
    OPTION_ALTERNATE_NICK,
    OPTION_USER_NAME,
    OPTION_REAL_NAME,
};

typedef struct
{
    gchar *name;
    SETUP_REC *rec;
}
OPTCATEGORY_REC;

extern OPTCATEGORY_REC option_categories[];
#define OPTION_CATEGORIES 9

extern SETUP_REC misc_options[];
extern SETUP_REC history_options[];
extern SETUP_REC flood_options[];
extern SETUP_REC completion_options[];
extern SETUP_REC lookandfeel_options[];
extern SETUP_REC ircproxy_options[];
extern SETUP_REC dcc_options[];
extern SETUP_REC appearance_options[];
extern SETUP_REC server_options[];

gchar *setup_tag_data(SETUP_REC *rec);
void setup_set_data(SETUP_REC *rec, gchar *section, gchar *value);

void setup_read(gchar *section, SETUP_REC *options);
void setup_free(SETUP_REC *options);

void settings_init(void);
void settings_deinit(void);

#endif
