/*
 lists.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

static gint compare_list(LIST_REC *p1, LIST_REC *p2)
{
    gint n;

    if (p1 == NULL) return -1;
    if (p2 == NULL) return 1;

    n = g_strcasecmp(p1->key, p2->key);
    return n;
}

/* add new item to list */
LIST_REC *list_add(GList **list, gchar *key, gchar *value)
{
    LIST_REC *rec;

    g_return_val_if_fail(list != NULL, NULL);
    g_return_val_if_fail(key != NULL, NULL);
    g_return_val_if_fail(value != NULL, NULL);

    rec = g_new(LIST_REC, 1);
    rec->key = g_strdup(key);
    rec->value = g_strdup(value);

    *list = g_list_insert_sorted(*list, rec, (GCompareFunc) compare_list);
    return rec;
}

/* remove item from list */
void list_remove(GList **list, LIST_REC *rec)
{
    g_return_if_fail(list != NULL);
    g_return_if_fail(rec != NULL);

    g_free(rec->key);
    g_free(rec->value);
    g_free(rec);

    *list = g_list_remove(*list, rec);
}

void list_set_value(LIST_REC *rec, gchar *value)
{
    g_return_if_fail(rec != NULL);
    g_return_if_fail(value != NULL);

    g_free(rec->value);
    rec->value = g_strdup(value);
}

LIST_REC *list_find(GList *list, gchar *key)
{
    LIST_REC *rec;
    GList *tmp;

    g_return_val_if_fail(key != NULL, NULL);

    for (tmp = g_list_first(list); tmp != NULL; tmp = tmp->next)
    {
        rec = tmp->data;
        if (g_strcasecmp(rec->key, key) == 0) return rec;
    }

    return NULL;
}
