/*
 setup-history.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"
#include "setup-int.h"

static gboolean sig_setup_apply(void)
{
    setup_write("history", history_options);
    return TRUE;
}

static gboolean setup_history(GtkWidget *dialog)
{
    GtkWidget *mainvbox, *table, *frame, *spin, *checkbox, *label;
    GtkAdjustment *adj;

    g_return_val_if_fail(dialog != NULL, FALSE);

    mainvbox = gtk_vbox_new(FALSE, 7);
    gtk_container_border_width(GTK_CONTAINER(mainvbox), 7);

    /* --- */
    frame = gtk_frame_new(_("History"));
    gtk_box_pack_start(GTK_BOX(mainvbox), frame, FALSE, FALSE, 0);

    table = gtk_table_new(3, 2, FALSE);
    gtk_container_border_width(GTK_CONTAINER(table), 5);
    gtk_container_add(GTK_CONTAINER(frame), table);

    checkbox = gtk_check_button_new_with_label(_("Each window has it's own command history buffer"));
    history_options[OPTION_WINDOW_HISTORY].widget = checkbox;
    gtk_table_attach(GTK_TABLE(table), checkbox, 0, 2, 0, 1, GTK_FILL, 0, 5, 0);

    label = gtk_label_new(_("Saved lines in scrollback buffer"));
    gtk_misc_set_alignment(GTK_MISC(label), 0, .5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2, GTK_FILL, 0, 5, 0);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) history_options[OPTION_MAX_TEXTWIDGET_LINES].data),
                                                0, G_MAXINT, 1, 10, 0);
    spin = gtk_spin_button_new(adj, 0, 0);
    history_options[OPTION_MAX_TEXTWIDGET_LINES].widget = spin;
    gtk_widget_set_usize(spin, 60, -1);
    gtk_table_attach(GTK_TABLE(table), spin, 1, 2, 1, 2, GTK_FILL, 0, 5, 0);

    label = gtk_label_new(_("Remove lines from buffer in blocks of"));
    gtk_misc_set_alignment(GTK_MISC(label), 0, .5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3, GTK_FILL, 0, 5, 0);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) history_options[OPTION_BLOCK_REMOVE_LINES].data),
                                                1, G_MAXINT, 1, 10, 0);
    spin = gtk_spin_button_new(adj, 0, 0);
    history_options[OPTION_BLOCK_REMOVE_LINES].widget = spin;
    gtk_widget_set_usize(spin, 60, -1);
    gtk_table_attach(GTK_TABLE(table), spin, 1, 2, 2, 3, GTK_FILL, 0, 5, 0);

    label = gtk_label_new(_("Command history length"));
    gtk_misc_set_alignment(GTK_MISC(label), 0, .5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 3, 4, GTK_FILL, 0, 5, 0);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) history_options[OPTION_MAX_COMMAND_HISTORY].data),
                                                0, G_MAXINT, 1, 7, 0);
    spin = gtk_spin_button_new(adj, 0, 0);
    history_options[OPTION_MAX_COMMAND_HISTORY].widget = spin;
    gtk_widget_set_usize(spin, 60, -1);
    gtk_table_attach(GTK_TABLE(table), spin, 1, 2, 3, 4, GTK_FILL, 0, 5, 0);

    label = gtk_label_new(_("Rawlog buffer length"));
    gtk_misc_set_alignment(GTK_MISC(label), 0, .5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 4, 5, GTK_FILL, 0, 5, 0);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) history_options[OPTION_RAWLOG_LINES].data),
                                                0, G_MAXINT, 1, 7, 0);
    spin = gtk_spin_button_new(adj, 0, 0);
    history_options[OPTION_RAWLOG_LINES].widget = spin;
    gtk_widget_set_usize(spin, 60, -1);
    gtk_table_attach(GTK_TABLE(table), spin, 1, 2, 4, 5, GTK_FILL, 0, 5, 0);

    setup_finish_init(dialog, history_options);

    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
                                   mainvbox, gtk_label_new(_("History")));
    return TRUE;
}

void init_history(void)
{
    signal_add("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_add("setup preferences", (SIGNAL_FUNC) setup_history);
}

void deinit_history(void)
{
    signal_remove("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_remove("setup preferences", (SIGNAL_FUNC) setup_history);
}
